package com.bxm.localnews.merchants.manage.impl;

import com.bxm.localnews.merchant.domain.BmManagerMapper;
import com.bxm.localnews.merchant.dto.BmInfoListDTO;
import com.bxm.localnews.merchant.dto.CategoryInfoDTO;
import com.bxm.localnews.merchant.dto.MerchantBmDetailDTO;
import com.bxm.localnews.merchant.param.BmEditParam;
import com.bxm.localnews.merchant.param.BmParam;
import com.bxm.localnews.merchant.param.MerchantBmListParam;
import com.bxm.localnews.merchants.facade.service.MerchantRedisRefreshFacade;
import com.bxm.localnews.merchants.manage.BmManagerService;
import com.bxm.newidea.component.vo.PageWarper;
import com.github.pagehelper.Page;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;

/**
 * @Author: pf.w
 * @Date: 2020/7/14 20:17
 */
@Service
@Log4j2
public class BmManagerServiceImpl implements BmManagerService {

    @Resource
    private BmManagerMapper bmManagerMapper;

    @Resource
    private MerchantRedisRefreshFacade merchantRedisRefresh;

    @Override
    public PageWarper<BmInfoListDTO> bmList(BmParam param) {
        MerchantBmListParam param1 = new MerchantBmListParam();
        BeanUtils.copyProperties(param, param1);
        List<BmInfoListDTO> list = bmManagerMapper.getList(param1);
        if (CollectionUtils.isEmpty(list)) {
            return new PageWarper<>();
        }

        //分页
        int start = (param.getPageNum() - 1) * param.getPageSize();
        int end = param.getPageNum() * param.getPageSize();
        if (start < 0) {
            start = 0;
        }
        if (end > list.size()) {
            end = list.size();
        }
        List<BmInfoListDTO> result = list.subList(start, end);
        Page page = new Page(param.getPageNum(), param.getPageSize());
        page.setTotal(list.size());
        page.addAll(result);
        return new PageWarper<>(page);
    }

    @Override
    public void saveAndEdit(BmEditParam param) {
        if (Objects.isNull(param.getId())) {
            bmManagerMapper.insert(param);
        } else {
            bmManagerMapper.update(param);
        }
        //存缓存
        merchantRedisRefresh.refreshMerchantList(param.getMerchantId());
    }

    @Override
    public List<CategoryInfoDTO> getCategoryInfo() {
        return bmManagerMapper.getCategoryList();
    }

    @Override
    public MerchantBmDetailDTO bmDetail(Long id) {
        if (Objects.isNull(id)) {
            return new MerchantBmDetailDTO();
        }
        return bmManagerMapper.detail(id);
    }
}
