package com.bxm.localnews.merchants.push;

import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.merchants.common.emuns.MerchantStatusEnum;
import com.bxm.localnews.merchants.vo.MerchantInfo;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.PushSoundEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.msg.sender.MessageSender;
import com.bxm.newidea.component.service.BaseService;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriUtils;

import javax.annotation.Resource;
import java.nio.charset.Charset;

/**
 * @author pf.w
 * @date 2020/9/29 15:23
 **/
@Service
public class MerchantPushService extends BaseService {
    @Resource
    private MessageSender messageSender;

    @Resource
    private DomainIntegrationService domainIntegrationService;

    /**
     * 资质认证
     */
    public void pushQualificationStatusMsg(MerchantInfo merchant, MerchantStatusEnum qualificationType, String remark) {
        String title;
        String content;
        if (MerchantStatusEnum.QUALIFICATION_SUCCESS.equals(qualificationType)) {
            //审核通过
            title = "资质认证成功";
            content = "您提交的资质认证已审核通过，赶快进入商家中心装修你的店铺吧~";
        } else {
            //审核失败
            title = "资质认证失败";
            content = "您提交的资质认证审核未通过,具体原因：\"" + remark + "\",请重新进行认证，有疑问可以联系客服哦~";
        }
        PushMessage message = getPushMessage(merchant, title, content);
        messageSender.sendPushMessage(message);
    }

    /**
     * 店铺上下架通知
     */
    public void pushShelfStatusMsg(MerchantInfo merchant, MerchantStatusEnum shelfType, String remark) {
        String title;
        String content;
        if (MerchantStatusEnum.SHELF_SUCCESS.equals(shelfType)) {
            title = "店铺恢复上架";
            content = "您的店铺已恢复上架，可以继续推广了哦~";
            logger.debug("您的店铺已恢复上架，可以继续推广了哦~");
        } else {
            //下架
            title = "店铺违规下架";
            content = "您的店铺涉及违规，已被下架，具体原因:\"" + remark + "\",请在店铺装修内进行修改。";
        }
        PushMessage message = getPushMessage(merchant, title, content);
        messageSender.sendPushMessage(message);
    }

    private PushMessage getPushMessage(MerchantInfo merchant, String title, String content) {
        PushPayloadInfo info = PushPayloadInfo.build(PushMessageEnum.JUMP_TYPE);
        info.setProtocol(buildProtocol(merchant));

        PushMessage message = PushMessage.build();
        message.setTitle(title);
        message.setContent(content);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPayloadInfo(info);
        message.setSound(PushSoundEnum.GOLD_SOUND);

        message.assign(merchant.getUserId());
        return message;
    }

    /**
     * 构建商户通知消息的跳转协议地址
     *
     * @return 组装的客户端协议，用于跳转到商家中心
     */
    private String buildProtocol(MerchantInfo merchant) {
        StringBuilder url = new StringBuilder();
        url.append(domainIntegrationService.getInnerH5BaseUrl())
                .append("/tk/merchant.html#/shopCenter?merchantId=").append(merchant.getId())
                .append("&userId={userId}")
                .append("&areaCode={areaCode}")
                .append("&areaName={areaName}");

        return "wst://web/webDetail?url=" + UriUtils.encode(url.toString(), Charset.defaultCharset());
    }
}
