package com.bxm.localnews.merchants.service;

import com.bxm.localnews.merchants.dto.MerchantCollectInfoDetailDTO;
import com.bxm.localnews.merchants.param.CollectMerchantParam;
import com.bxm.localnews.merchants.param.MerchantCollectListParam;
import com.bxm.newidea.component.vo.PageWarper;

/**
 * @author : pf.w
 * @date : 2020/7/14 11:18
 *
 *
 * 商家 收藏 接口相关（收藏商品，取消收藏，收藏列表）
 */

public interface MerchantCollectService {

    /**
     *
     * 商家 收藏 | 取消  动作
     *
     * @param param 收藏动作参数
     * @return 动作结果  成功 true | 失败 false
     */
    boolean collectMerchant(CollectMerchantParam param);

    /**
     *
     * 获取收藏列表
     *
     * @param param 上行参数
     * @return 返回收藏列表分页信息
     */
    PageWarper<MerchantCollectInfoDetailDTO> getCollectList(MerchantCollectListParam param);

}
