package com.bxm.localnews.merchants.service;

import com.bxm.localnews.merchants.dto.MerchantInfoDto;
import com.bxm.localnews.merchants.vo.MerchantInfo;

/**
 * 商家信息入库更新动作封装
 *
 * @author: pf.w
 * @date: 2020/9/25 10:32
 **/
public interface MerchantInfoDbService {
    /**
     * 保存商家信息
     *
     * @param info 商家实体
     * @return 成功 ：true | 失败 ：false
     */
    boolean saveMerchant(MerchantInfo info);


    /**
     * 更新商家信息
     *
     * @param info 商家实体
     * @return 成功 ：true | 失败 ：false
     */
    boolean updateMerchant(MerchantInfo info);

    /**
     * 删除商家信息
     *
     * @param userId ： 用户id
     * @return ： 成功 true | 失败 false
     */
    boolean deleteMerchantInfoByUid(Long userId);

    /**
     * 获取商家详情
     *
     * @param merchantId 商家ID
     * @return 商家详情实体
     */
    MerchantInfo getMerchantInfo(Long merchantId);

    /**
     * 获取商家的信息(截取过头图操作等，返回DTO详情实体)
     *
     * @param merchantId 商家ID
     * @return 商家信息
     */
    MerchantInfoDto getMerchantInfoDetail(Long merchantId);

}
