package com.bxm.localnews.merchants.service;


import com.bxm.localnews.merchants.dto.MerchantStatusDto;
import com.bxm.localnews.merchants.param.*;
import com.bxm.localnews.merchants.vo.MerchantInfoSimpleVO;
import com.bxm.newidea.component.vo.Message;

/**
 * @author : pf.w
 * @date: 2020/7/13 13:58
 */
public interface MerchantInfoService {
    /**
     * 获取店铺详情
     *
     * @param merchantId 商户ID
     * @return 店铺详情
     */
    Message getMerchantInfoDetail(Long merchantId);


    /**
     * 商户提交入驻信息
     *
     * @param merchantIntoApplyParam 入驻请求参数
     * @return 是否入驻成功
     */
    Message enter(MerchantIntoApplyParam merchantIntoApplyParam);

    /**
     * 更新店铺信息
     *
     * @param merchantInfoParam 商户变更参数
     * @return 更新是否成功
     */
    Message updateMerchantInfo(MerchantInfoParam merchantInfoParam);

    /**
     * 提交资质信息
     *
     * @param merchantAuthInfoParam 商户审核参数
     * @return 提交是否成功
     */
    Message authApply(MerchantAuthInfoParam merchantAuthInfoParam);

    /**
     * 获取商家中心基本信息
     *
     * @param merchantId 商户ID
     * @return 获取商家资质, 装修, 可用推广金, 是否进入会员中心信息等商家基本信息
     */
    Message getBusinessInfo(Long merchantId);

    /**
     * 获取店铺状态信息,显示不同的文案,跳转不同的页面
     *
     * @param param param
     * @return 未完成资质认证文案为“商家合作,完成资质认证文案为“商家中心,未申请入驻点击进入入驻申请页面,已申请入驻点击进入商家中心
     */
    MerchantStatusDto getStatus(MerchantStatusParam param);

    /**
     * 用户点击进入会员中心
     * 进入会员中心加标记,第一次进入redis写入key为商户id,判断key的值来确定是否为第一次进入
     *
     * @param merchantId 商户ID
     */
    void clickCenter(Long merchantId);

    /**
     * 根据商户ID获取商家信息
     *
     * @param merchantId 商户ID
     * @return 商家入驻信息
     */
    MerchantIntoInfoDto getMerchantInfo(Long merchantId);


    /**
     * 获取商户信息通过商品id  (已废弃)
     *
     * @param goodsId 商品id
     * @return 商户信息
     */
    @Deprecated
    MerchantInfoSimpleVO getSimpleMerchantInfoByGoodsId(Long goodsId);
}
