package com.bxm.localnews.merchants.service;

import com.bxm.localnews.merchants.dto.MerchantChannelInfo;
import com.bxm.localnews.merchants.dto.MerchantDetailDTO;
import com.bxm.localnews.merchants.dto.MerchantWorkListDTO;
import com.bxm.localnews.merchants.dto.MerchantWorkV2ListDTO;
import com.bxm.localnews.merchants.param.MerChantListParam;
import com.bxm.localnews.merchants.param.MerchantDetailParam;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.List;

/**
 * @Author: pf.w
 * @Date: 2020/7/13 13:58
 * <p>
 * 商家列表相关 （商家列表；商家详情；频道推荐列表）
 */

public interface MerchantListService {

    /**
     * merchant list info 商家列表
     *
     * @param param
     * @return
     */
    PageWarper<MerchantWorkListDTO> getMerchantList(MerChantListParam param);

    /**
     * merchant detail info 商家详情
     *
     * @param param
     * @return
     */
    MerchantDetailDTO getMerchantDetail(MerchantDetailParam param);

    /**
     * load from db and save redis
     *
     * @param param
     * @return
     */
    List<MerchantWorkListDTO> getFromDb(MerChantListParam param);

    /**
     * 清理列表缓存，包括全类型缓存
     *
     * @param areaCode   地区编码
     * @param categoryId 商户所属类型
     */
    void removeCache(String areaCode, Long categoryId);

    /**
     * merchant channel qiu qu info  商家分类页球区位商家列表
     *
     * @param param
     * @return
     */
    List<MerchantChannelInfo> getChannelQuMerchantList(MerChantListParam param);

    /**
     * merchant list info 商家列表V2区分团购商品+优惠券
     *
     * @param param
     * @return
     */
    PageWarper<MerchantWorkV2ListDTO> merchantListInfoV2(MerChantListParam param);
}
