package com.bxm.localnews.merchants.service.impl;

import com.bxm.localnews.merchant.dto.LocationDTO;
import com.bxm.localnews.merchant.integration.LocationIntegrationService;
import com.bxm.localnews.merchants.param.MerchantIntoApplyParam;
import com.bxm.localnews.merchants.supporter.LocationHelper;
import com.bxm.localnews.merchants.vo.MerchantInfo;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.BeanUtils;

import javax.annotation.Resource;

/**
 * 商户信息管理基类
 *
 * @author liujia
 * @date 2020-08-22 16:45
 **/
public class BaseMerchantInfoService extends BaseService {

    @Resource
    private LocationHelper locationHelper;

    @Resource
    private LocationIntegrationService locationIntegrationService;

    /**
     * 填充商户信息的一些基础数据
     * 包括：商户的城市定位信息、经纬度信息
     *
     * @param merchantInfoParam 商户变更请求参数
     * @return 商户详情
     */
    public MerchantInfo fillMerchantInfo(MerchantIntoApplyParam merchantInfoParam) {
        //店铺名称&行业在提交认证信息接口修改 修改店铺不可修改
        MerchantInfo merchantInfo = new MerchantInfo();
        BeanUtils.copyProperties(merchantInfoParam, merchantInfo);
        merchantInfo.setId(merchantInfoParam.getMerchantId());

        locationHelper.fillLocation(merchantInfo);

        // 填充商户的所属地区
        fillAreaCode(merchantInfo);
        return merchantInfo;
    }

    /**
     * 填充商家的所属地区信息，当前逻辑如下：
     * 根据商户的所属区县（countyCode、cityCode）依次获取是否存在对应的开通城市
     * 如果存在开通城市，则设置为商户的所属地区
     *
     * @param merchantInfo 商户信息
     */
    private void fillAreaCode(MerchantInfo merchantInfo) {
        LocationDTO locationDTO = locationIntegrationService.getLocationByGeocode(merchantInfo.getCountyCode());

        if (StringUtils.isNotBlank(locationDTO.getName())) {
            merchantInfo.setAreaCode(locationDTO.getCode());
        } else {
            locationDTO = locationIntegrationService.getLocationByGeocode(merchantInfo.getCityCode());
            if (StringUtils.isNotBlank(locationDTO.getName())) {
                merchantInfo.setAreaCode(locationDTO.getCode());
            }
        }

        logger.info("商户城市定位：{},区县定位:{}，最终定位：{}",
                merchantInfo.getCityCode(),
                merchantInfo.getCountyCode(),
                merchantInfo.getAreaCode());
    }
}
