package com.bxm.localnews.merchants.supporter;

import com.bxm.localnews.merchant.dto.LocationDTO;
import com.bxm.localnews.merchant.integration.LocationIntegrationService;
import com.bxm.localnews.merchants.vo.MerchantInfo;
import com.bxm.newidea.component.geo.dto.Coordinate;
import com.bxm.newidea.component.geo.service.GeoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;

import static org.apache.commons.lang.StringUtils.isNotBlank;

/**
 * @author liujia
 * @date 2020-08-25 11:11
 **/
@Component
@Slf4j
public class LocationHelper {

    @Resource
    private LocationIntegrationService locationIntegrationService;

    @Resource
    private GeoService geoService;

    /**
     * 填充商户定位信息
     *
     * @param info 商户信息
     */
    public boolean fillLocation(MerchantInfo info) {
        if (null == info) {
            return false;
        }

        boolean changeFlag = false;
        String address = "";

        if (isNotBlank(info.getCountyCode()) && isNotBlank(info.getAddress())) {
            // 根据选择的地区编码与详细地址组成最终的详情地址，用于从高德SDK获取经纬度信息
            LocationDTO locationByGeocode = locationIntegrationService.getLocationByGeocode(info.getCountyCode());
            if (locationByGeocode != null) {
                address = locationByGeocode.getFullName() + info.getAddress();
            }

            if (isNotBlank(address)) {
                Coordinate coordinate = geoService.getCoordinate(address);
                if (coordinate != null) {
                    if (coordinate.getLatitude() != null) {
                        info.setLat(BigDecimal.valueOf(coordinate.getLatitude()));
                    }
                    if (coordinate.getLongitude() != null) {
                        info.setLng(BigDecimal.valueOf(coordinate.getLongitude()));
                    }

                    changeFlag = true;
                }
            }
        }

        if (log.isDebugEnabled()) {
            log.debug("设置经纬度信息，商家ID：{},地址信息：{},解析的经纬度：{} - {}",
                    info.getId(),
                    address,
                    info.getLat(),
                    info.getLng());
        }

        return changeFlag;
    }
}
