package com.bxm.localnews.merchants.timer;

import com.bxm.localnews.merchant.domain.MerchantInfoMapper;
import com.bxm.localnews.merchants.service.MerchantInfoDbService;
import com.bxm.localnews.merchants.supporter.LocationHelper;
import com.bxm.localnews.merchants.vo.MerchantInfo;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * 修复商户的定位
 *
 * @author liujia
 * @date 2020-08-25 10:55
 **/
@Component
public class FixMerchantLocationTask extends AbstractCronTask<String> {

    @Resource
    private MerchantInfoMapper merchantInfoMapper;

    @Resource
    private LocationHelper locationHelper;

    @Resource
    private MerchantInfoDbService merchantInfoDbService;

    @Override
    public ReturnT<String> service(String s) {
        List<MerchantInfo> merchantInfos = merchantInfoMapper.queryUnknownLocationList();

        if (CollectionUtils.isNotEmpty(merchantInfos)) {
            merchantInfos.stream().parallel().forEach(merchant -> {
                if (locationHelper.fillLocation(merchant)) {
                    merchantInfoDbService.updateMerchant(merchant);
                }
            });
        }
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return getClass().getSimpleName();
    }

    @Override
    public String cron() {
        return "0 0 3 * * ? *";
    }
}
