package com.bxm.localnews.merchants.timer;

import com.bxm.localnews.merchants.cache.MerchantRedisRefresh;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 定期同步已审核通过用户的缓存
 * 也作为初始化的入口之一
 *
 * @author liujia
 * @date 2020-08-22 18:23
 **/
@Component
public class MerchantUserCacheRefreshTask extends AbstractCronTask {

    @Resource
    private MerchantRedisRefresh merchantRedisRefresh;

    @Override
    protected ReturnT<String> service(Object o) {
        merchantRedisRefresh.initCache();
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return getClass().getSimpleName();
    }

    @Override
    public String cron() {
        return "0 0 * ? * *";
    }
}
