/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.merchants.timer;

import com.bxm.localnews.merchant.domain.MerchantPrerogativeInfoMapper;
import com.bxm.localnews.merchant.entity.MerchantPrerogativeInfoEntity;
import com.bxm.localnews.merchants.cache.MerchantRedisRefresh;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author jieliGG
 * @date 2020/7/21 9:59
 * 商家权益过期task
 **/
@Component
public class MerchantVipTimeoutTask extends AbstractCronTask<String> {

    private final MerchantPrerogativeInfoMapper merchantPrerogativeInfoMapper;

    private final MerchantRedisRefresh merchantRedisRefresh;

    @Autowired
    public MerchantVipTimeoutTask(MerchantPrerogativeInfoMapper merchantPrerogativeInfoMapper,
                                  MerchantRedisRefresh merchantRedisRefresh) {
        this.merchantPrerogativeInfoMapper = merchantPrerogativeInfoMapper;
        this.merchantRedisRefresh = merchantRedisRefresh;
    }

    @Override
    protected ReturnT<String> service(String callbackParam) {
        //获取过期的权益
        List<MerchantPrerogativeInfoEntity> timeoutList = merchantPrerogativeInfoMapper.getTimeoutList();

        if (!CollectionUtils.isEmpty(timeoutList)) {
            List<Long> timeoutIds = new ArrayList<>(timeoutList.size());
            for (MerchantPrerogativeInfoEntity entity : timeoutList) {
                timeoutIds.add(entity.getId());
                //权益过期，删除VIP缓存信息
                //清空商家缓存
                merchantRedisRefresh.refreshMerchantList(entity.getMerchantId());
            }
            //更新权益过期
            merchantPrerogativeInfoMapper.updateTimeoutInfo(timeoutIds);
        }
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "MERCHANT_PREROGATIVE_TIME_OUT_TASK";
    }

    @Override
    public String cron() {
        return "0 0 0 * * ?";
    }

    @Override
    public String description() {
        return "商家权益过期定时任务[包括vip和广告]";
    }
}
