package com.bxm.localnews.message.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.message.dto.MessageNumVo;
import com.bxm.localnews.message.param.MessageListParam;
import com.bxm.localnews.message.service.MessageService;
import com.bxm.localnews.message.service.MessageUserService;
import com.bxm.localnews.message.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@Api(tags = "5-01 用户消息列表", description = "获取用户的未读消息")
@RestController
@RequestMapping("api/msg")
public class MessageController {

    @Resource
    private MessageService messageService;

    @Resource
    private MessageUserService messageUserService;

    @ApiOperation(value = "5-01-1 获取用户消息列表", notes = "")
    @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    @RequestMapping(value = "list", method = RequestMethod.GET)
    public Json<PageWarper<Message>> getList(@Validated MessageListParam messageListParam) {
        return Json.build((this.messageService.listMessage(messageListParam)));
    }

    @ApiOperation(value = "5-01-2 获取最新消息条数", notes = "")
    @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    @RequestMapping(value = "newMsg", method = RequestMethod.GET)
    public Json<MessageNumVo> getNewMsg(@RequestParam(value = "userId") Long userId) {
        int num = this.messageService.getNewMsg(userId);
        MessageNumVo messageNumVo = new MessageNumVo();
        messageNumVo.setNum(num);
        return ResultUtil.genSuccessResult(messageNumVo);
    }

    @ApiOperation(value = "5-01-3 清空消息", notes = "")
    @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    @RequestMapping(value = "delete", method = RequestMethod.GET)
    public Json updateById(@RequestParam(value = "userId") Long userId) {
        return this.messageUserService.updateById(userId);
    }

    @ApiOperation(value = "5-01-4 更新消息为已读/删除", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
            @ApiImplicitParam(name = "id", value = "消息id", required = true),
            @ApiImplicitParam(name = "status", value = "状态值", required = true)
    })
    @RequestMapping(value = "read/delete", method = RequestMethod.GET)
    public Json updateById(@RequestParam(value = "userId") Long userId,
                           @RequestParam(value = "id") Integer id,
                           @RequestParam(value = "status") Byte status) {
        return this.messageUserService.updateOrDelete(id, status, userId);
    }

    @ApiOperation(value = "5-01-5 公告列表", notes = "")
    @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    @RequestMapping(value = "notice/list", method = RequestMethod.GET)
    public Json<List<Message>> notices(@RequestParam(value = "userId", required = false) Long userId, MPage page) {
        if (page == null) {
            page = new MPage();
        }
        page.checkPage();
        List<Message> list = this.messageService.queryNoticeList(userId, page);
        return ResultUtil.genSuccessResultWithPage(list, page);
    }

    @ApiOperation(value = "5-01-6 公告详情", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
            @ApiImplicitParam(name = "id", value = "消息id", required = true)
    })
    @RequestMapping(value = "notice/detail", method = RequestMethod.GET)
    public Json<Message> noticeDetail(@RequestParam(value = "id", required = false) Integer id,
                                      @RequestParam(value = "userId", required = false) Long userId) {
        this.messageUserService.updateOrDelete(id, (byte) 1, userId);
        Message msg = this.messageService.noticeDetail(id);
        return ResultUtil.genSuccessResult(msg);
    }

}

