package com.bxm.localnews.message.param;

import java.util.List;

import javax.validation.constraints.NotNull;

import com.bxm.newidea.component.vo.PageParam;
import com.google.common.collect.Lists;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Created by Arei on 2018/10/25.
 */
@ApiModel(description = "消息参数")
public class MessageListParam extends PageParam {
    @NotNull
    private Long userId;

    @ApiModelProperty("地区编码")
    private String areaCode;

    @ApiModelProperty("消息类型参数列表")
    private List<String> msgTypeList = Lists.newArrayList();

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public List<String> getMsgTypeList() {
        return msgTypeList;
    }

    public void setMsgTypeList(List<String> msgTypeList) {
        this.msgTypeList = msgTypeList;
    }
}
