/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.message.service.impl;

import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.message.domain.MessageMapper;
import com.bxm.localnews.message.param.MessageListParam;
import com.bxm.localnews.message.param.MessageParam;
import com.bxm.localnews.message.service.MessageService;
import com.bxm.localnews.message.vo.Message;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.SendStateEunm;
import com.bxm.localnews.mq.common.constant.SendTypeEunm;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class MessageServiceImpl
implements MessageService {
    @Resource
    private MessageMapper messageMapper;
    @Resource
    private RedisStringAdapter redisStringAdapter;

    @Override
    public List<Message> queryList(Long userId, MPage page) {
        return this.messageMapper.queryList(userId, page);
    }

    @Override
    public int getNewMsg(Long userId) {
        int num = this.messageMapper.getNewMsg(userId);
        return num > 0 ? num : 0;
    }

    @Override
    public List<Message> queryMessageList(Map<String, Object> map) {
        List messageList = this.messageMapper.selectMsgList(map);
        for (Message message : messageList) {
            message.setTypeStr(PushMessageEnum.getMessageDescByType((String)message.getMsgType()));
        }
        return messageList;
    }

    @Override
    public Message selectByPrimaryKey(Long id) {
        Message messageInfo = this.messageMapper.selectByPrimaryKey(Integer.valueOf(id.intValue()));
        if (null != messageInfo) {
            if (!StringUtils.isEmpty((CharSequence)String.valueOf(messageInfo.getSendType()))) {
                messageInfo.setSendTypeStr(SendTypeEunm.getSendByType((String)String.valueOf(messageInfo.getSendType())));
            }
            if (!StringUtils.isEmpty((CharSequence)String.valueOf(messageInfo.getSendState()))) {
                messageInfo.setSendStateStr(SendStateEunm.getSendByState((String)String.valueOf(messageInfo.getSendState())));
            }
            if (!StringUtils.isEmpty((CharSequence)messageInfo.getSendTime())) {
                messageInfo.setSendTime(messageInfo.getSendTime().substring(0, messageInfo.getSendTime().indexOf(".")));
            }
        }
        return messageInfo;
    }

    @Override
    public int insertSelective(Message record) {
        return this.messageMapper.insertSelective(record);
    }

    @Override
    public List<Message> queryList(String userId) {
        List messageList = this.messageMapper.selectList();
        return messageList;
    }

    @Override
    public PageWarper<Message> queryMessages(MessageParam messageParam) {
        Preconditions.checkArgument((messageParam != null ? 1 : 0) != 0);
        PageWarper pageWarper = new PageWarper(this.messageMapper.selectAdminMsgList(messageParam));
        for (Message message : pageWarper.getList()) {
            message.setTypeStr(PushMessageEnum.getMessageDescByType((String)message.getMsgType()));
            message.setSendTypeStr(SendTypeEunm.getSendByType((String)String.valueOf(message.getSendType())));
            message.setSendStateStr(SendStateEunm.getSendByState((String)String.valueOf(message.getSendState())));
            if (StringUtils.isEmpty((CharSequence)message.getSendTime())) continue;
            message.setSendTime(message.getSendTime().substring(0, message.getSendTime().indexOf(".")));
        }
        return pageWarper;
    }

    @Override
    public int updateByPrimaryKeySelective(Message record) {
        return this.messageMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public int deleteByPrimaryKey(Long id) {
        return this.messageMapper.deleteByPrimaryKey(Integer.valueOf(id.intValue()));
    }

    @Override
    public Message selectByMap(Map<String, Object> map) {
        return this.messageMapper.selectByMap(map);
    }

    @Override
    public Message selectLastOne() {
        return this.messageMapper.selectLastOne();
    }

    @Override
    public List<Message> queryNoticeList(Long userId, MPage page) {
        List list = this.messageMapper.queryNoticeList(userId, page);
        return list;
    }

    @Override
    public Message noticeDetail(Integer id) {
        return this.messageMapper.selectByPrimaryKey(id);
    }

    @Override
    public PageWarper<Message> listMessage(MessageListParam messageListParam) {
        PageWarper messagePageWarper = new PageWarper(this.messageMapper.listMessage(messageListParam));
        KeyGenerator redPointKey = RedisConfig.MSG_RED_POINT.copy().appendKey((Object)messageListParam.getUserId());
        this.redisStringAdapter.set(redPointKey, (Object)false);
        return messagePageWarper;
    }

    @Override
    public int saveMsg(Message msg) {
        int result = this.messageMapper.insertSelective(msg);
        KeyGenerator redPointKey = RedisConfig.MSG_RED_POINT.copy().appendKey((Object)msg.getUserId());
        this.redisStringAdapter.set(redPointKey, (Object)true);
        return result;
    }
}

