/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.message.service.impl;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.message.domain.MessageMapper;
import com.bxm.localnews.message.domain.MessageUserMapper;
import com.bxm.localnews.message.service.MessageUserService;
import com.bxm.localnews.message.vo.Message;
import com.bxm.localnews.message.vo.MessageUser;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@Transactional(rollbackFor={Exception.class})
public class MessageUserServiceImpl
implements MessageUserService {
    @Resource
    private transient MessageUserMapper messageUserMapper;
    @Resource
    private transient MessageMapper messageMapper;

    @Override
    public Json updateById(Long userId) {
        Message message = new Message(userId, Byte.valueOf((byte)2));
        this.messageMapper.updateByUserId(message);
        return ResultUtil.genSuccessResult();
    }

    @Override
    public Json updateOrDelete(Integer id, Byte status, Long userId) {
        Message message = this.messageMapper.selectByPrimaryKey(id);
        if (message.getUserId() == 0L) {
            this.saveUpdateCommonMsg(id, status, userId);
        } else {
            this.updateMsg(id, status, userId);
        }
        return ResultUtil.genSuccessResult();
    }

    private void updateMsg(Integer id, Byte status, Long userId) {
        this.messageMapper.updateMsg(id, status, userId);
    }

    private void saveUpdateCommonMsg(Integer id, Byte status, Long userId) {
        MessageUser messageUser = this.messageUserMapper.selectByMsgId(id, userId);
        if (ObjectUtils.isEmpty((Object)messageUser)) {
            MessageUser insertMsg = new MessageUser(userId, id, status);
            this.messageUserMapper.insertSelective(insertMsg);
        } else {
            messageUser.setStatus(status);
            this.messageUserMapper.updateByPrimaryKeySelective(messageUser);
        }
    }
}

