package com.bxm.localnews.message.service.impl;

import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import com.bxm.localnews.base.dto.LocationDTO;
import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.message.domain.MessageMapper;
import com.bxm.localnews.message.param.MessageListParam;
import com.bxm.localnews.message.param.MessageParam;
import com.bxm.localnews.message.service.MessageService;
import com.bxm.localnews.message.vo.Message;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.SendStateEunm;
import com.bxm.localnews.mq.common.constant.SendTypeEunm;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * Created by Administrator on 2018/2/9 0009.
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class MessageServiceImpl implements MessageService {

    @Resource
    private MessageMapper messageMapper;

    @Resource
    private RedisStringAdapter redisStringAdapter;

    @Autowired
    private LocationFacadeService locationFacadeService;

    @Override
    public List<Message> queryList(Long userId, MPage page) {
        return this.messageMapper.queryList(userId, page);
    }

    @Override
    public int getNewMsg(Long userId) {
        int num = this.messageMapper.getNewMsg(userId);
        return num > 0 ? num : 0;
    }

    @Override
    public List<Message> queryMessageList(Map<String, Object> map) {
        List<Message> messageList = this.messageMapper.selectMsgList(map);
        for (Message message : messageList) {
            message.setTypeStr(PushMessageEnum.getMessageDescByType(message.getMsgType()));
        }
        return messageList;
    }

    @Override
    public Message selectByPrimaryKey(Long id) {
        Message messageInfo = this.messageMapper.selectByPrimaryKey(id.intValue());
        if (null != messageInfo) {
            if (!StringUtils.isEmpty(String.valueOf(messageInfo.getSendType()))) {
                messageInfo.setSendTypeStr(SendTypeEunm.getSendByType(String.valueOf(messageInfo.getSendType())));
            }
            if (!StringUtils.isEmpty(String.valueOf(messageInfo.getSendState()))) {
                messageInfo.setSendStateStr(SendStateEunm.getSendByState(String.valueOf(messageInfo.getSendState())));
            }
            if (!StringUtils.isEmpty(messageInfo.getSendTime())) {
                messageInfo.setSendTime(messageInfo.getSendTime().substring(0, messageInfo.getSendTime().indexOf(".")));
            }
        }
        return messageInfo;
    }

    @Override
    public int insertSelective(Message record) {
        return this.messageMapper.insertSelective(record);
    }

    @Override
    public List<Message> queryList(String userId) {
        List<Message> messageList = this.messageMapper.selectList();
        return messageList;
    }

    @Override
    public PageWarper<Message> queryMessages(MessageParam messageParam) {
        Preconditions.checkArgument(messageParam != null);

        PageWarper<Message> pageWarper = new PageWarper<>(this.messageMapper.selectAdminMsgList(messageParam));
        for (Message message : pageWarper.getList()) {
            message.setTypeStr(PushMessageEnum.getMessageDescByType(message.getMsgType()));
            message.setSendTypeStr(SendTypeEunm.getSendByType(String.valueOf(message.getSendType())));
            message.setSendStateStr(SendStateEunm.getSendByState(String.valueOf(message.getSendState())));
            if (!StringUtils.isEmpty(message.getSendTime())) {
                message.setSendTime(message.getSendTime().substring(0, message.getSendTime().indexOf(".")));
            }
        }

        return pageWarper;
    }

    @Override
    public int updateByPrimaryKeySelective(Message record) {
        return this.messageMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public int deleteByPrimaryKey(Long id) {
        return this.messageMapper.deleteByPrimaryKey(id.intValue());
    }

    @Override
    public Message selectByMap(Map<String, Object> map) {
        return this.messageMapper.selectByMap(map);
    }

    @Override
    public Message selectLastOne() {
        return this.messageMapper.selectLastOne();
    }

    @Override
    public List<Message> queryNoticeList(Long userId, MPage page) {
        List<Message> list = this.messageMapper.queryNoticeList(userId, page);
        return list;
    }

    @Override
    public Message noticeDetail(Integer id) {
        return this.messageMapper.selectByPrimaryKey(id);
    }

    @Override
    public PageWarper<Message> listMessage(MessageListParam messageListParam) {
        if (StringUtils.isNotBlank(messageListParam.getAreaCode())) {
            LocationDTO locationDTO = locationFacadeService.getLocationByCode(messageListParam.getAreaCode());
            if (locationDTO == null || locationDTO.getEnableVip() == 0) {
                //vip类型的消息不查看
                messageListParam.setMsgTypeList(Lists.newArrayList("30", "31", "32", "33", "34"));
            }
        }
        PageWarper<Message> messagePageWarper = new PageWarper<>(messageMapper.listMessage(messageListParam));
        //通知红点设置
        KeyGenerator redPointKey = RedisConfig.MSG_RED_POINT.copy().appendKey(messageListParam.getUserId());
        redisStringAdapter.set(redPointKey, false);

        if (null != messageListParam.getUserId()) {
            Message message = new Message();
            message.setStatus((byte) 1);
            message.setUserId(messageListParam.getUserId());
            messageMapper.updateByUserId(message);
        }

        return messagePageWarper;
    }

    @Override
    public int saveMsg(Message msg) {
        int result = messageMapper.insertSelective(msg);

        //通知红点设置
        KeyGenerator redPointKey = RedisConfig.MSG_RED_POINT.copy().appendKey(msg.getUserId());
        redisStringAdapter.set(redPointKey, true);

        return result;
    }

}
