/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.mq.consume.service.MessageService;
import com.bxm.localnews.mq.consume.service.MessageUserService;
import com.bxm.localnews.msg.dto.MessageNumDTO;
import com.bxm.localnews.msg.dto.MessageTypeDTO;
import com.bxm.localnews.msg.param.MessageListParam;
import com.bxm.localnews.msg.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"5-01 \u7528\u6237\u6d88\u606f\u5217\u8868"}, description="\u83b7\u53d6\u7528\u6237\u7684\u672a\u8bfb\u6d88\u606f")
@RestController
@RequestMapping(value={"api/msg"})
public class MessageController {
    @Resource
    private MessageService messageService;
    @Resource
    private MessageUserService messageUserService;

    @ApiOperation(value="5-01-1 \u6839\u636e\u7c7b\u578b\u83b7\u53d6\u7528\u6237\u6d88\u606f\u5217\u8868", notes="\u6839\u636emsgType\u83b7\u53d6\u6240\u6709\u7684\u6d88\u606f\u5217\u8868,type:INTERACTION(\u4e92\u52a8\u6d88\u606f)\u3001SYSTEM(\u7cfb\u7edf\u901a\u77e5)\u3001NEWS(\u70ed\u95fb)\u3001BALANCE(\u4f59\u989d)\u3001COMMENT(\u8bc4\u8bba)\u3001LIKE(\u70b9\u8d5e)\u3001SHARE(\u5206\u4eab)\u3001INVITE(\u9080\u8bf7)")
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true)
    @RequestMapping(value={"list"}, method={RequestMethod.GET})
    public Json<PageWarper<Message>> getList(@Validated MessageListParam messageListParam, BasicParam basicParam) {
        return Json.build((Object)this.messageService.listMessage(messageListParam, basicParam));
    }

    @ApiOperation(value="5-01-2 \u83b7\u53d6\u6700\u65b0\u6d88\u606f\u6761\u6570", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true), @ApiImplicitParam(name="platform", value="\u5e73\u53f0\u7c7b\u578b", required=true)})
    @RequestMapping(value={"newMsg"}, method={RequestMethod.GET})
    public Json<MessageNumDTO> getNewMsg(@RequestParam(value="userId") Long userId, @RequestParam(value="platform") Integer platform) {
        int num = this.messageService.getUnReadMsg(userId, platform);
        MessageNumDTO messageNumDTO = new MessageNumDTO();
        messageNumDTO.setNum(num);
        return ResultUtil.genSuccessResult((Object)messageNumDTO);
    }

    @ApiOperation(value="5-01-3 \u6e05\u7a7a\u6d88\u606f", notes="")
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true)
    @RequestMapping(value={"delete"}, method={RequestMethod.GET})
    public Json updateById(@RequestParam(value="userId") Long userId) {
        return this.messageUserService.updateById(userId);
    }

    @ApiOperation(value="5-01-4 \u66f4\u65b0\u6d88\u606f\u4e3a\u5df2\u8bfb/\u5220\u9664", notes="\u6839\u636emsgType\u83b7\u53d6\u6240\u6709\u7684\u6d88\u606f\u5217\u8868,type:INTERACTION(\u4e92\u52a8\u6d88\u606f)\u3001SYSTEM(\u7cfb\u7edf\u901a\u77e5)\u3001NEWS(\u70ed\u95fb)\u3001BALANCE(\u4f59\u989d)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true), @ApiImplicitParam(name="id", value="\u6d88\u606fid", required=false), @ApiImplicitParam(name="status", value="\u72b6\u6001\u503c", required=true), @ApiImplicitParam(name="messageType", value="\u6d88\u606f\u7c7b\u578b", required=true)})
    @RequestMapping(value={"read/delete"}, method={RequestMethod.GET})
    public Json updateById(@RequestParam(value="userId") Long userId, @RequestParam(value="id", required=false) Integer id, @RequestParam(value="status") Byte status, @RequestParam(value="messageType") String messageType) {
        return this.messageUserService.updateOrDelete(id, status, userId, messageType);
    }

    @ApiOperation(value="5-01-5 \u516c\u544a\u5217\u8868", notes="")
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true)
    @RequestMapping(value={"notice/list"}, method={RequestMethod.GET})
    public Json<List<Message>> notices(@RequestParam(value="userId", required=false) Long userId, MPage page) {
        if (page == null) {
            page = new MPage();
        }
        page.checkPage();
        List list = this.messageService.queryNoticeList(userId, page);
        return ResultUtil.genSuccessResultWithPage((Object)list, (MPage)page);
    }

    @ApiOperation(value="5-01-6 \u516c\u544a\u8be6\u60c5", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true), @ApiImplicitParam(name="id", value="\u6d88\u606fid", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true), @ApiImplicitParam(name="messageType", value="\u6d88\u606f\u7c7b\u578b", required=false)})
    @RequestMapping(value={"notice/detail"}, method={RequestMethod.GET})
    public Json<Message> noticeDetail(@RequestParam(value="id", required=false) Integer id, @RequestParam(value="userId", required=false) Long userId, @RequestParam(value="messageType", required=false) String messageType) {
        this.messageUserService.updateOrDelete(id, Byte.valueOf((byte)1), userId, messageType);
        Message msg = this.messageService.noticeDetail(id);
        return ResultUtil.genSuccessResult((Object)msg);
    }

    @ApiOperation(value="5-01-7 \u83b7\u53d6\u6d88\u606f\u7c7b\u578b\u53ca\u5176\u5e7f\u544a\u5217\u8868", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="userId", value="\u7528\u6237id", paramType="query", dataType="String")})
    @RequestMapping(value={"type"}, method={RequestMethod.GET})
    public Json<MessageTypeDTO> getMessageTypes(@RequestParam(value="areaCode") String areaCode, @RequestParam(value="userId") Long userId, BasicParam basicParam) {
        return ResultUtil.genSuccessResult((Object)this.messageService.getMessageType(areaCode, userId, basicParam));
    }
}

