package com.bxm.localnews.msg.controller;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.msg.dto.InteractMessageDTO;
import com.bxm.localnews.msg.param.InteractMessageParam;
import com.bxm.localnews.msg.service.UserMessageService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 互动消息相关接口
 *
 * @author wzy
 * @version 1.0
 * @date 2020/9/21 10:50 上午
 */
@Api(tags = "5-05 互动消息相关接口")
@RestController
@RequestMapping("{version}/msg/interact")
public class InteractMessageController {

    private final UserMessageService userMessageService;

    public InteractMessageController(UserMessageService userMessageService) {
        this.userMessageService = userMessageService;
    }

    @ApiOperation(value = "5-05-1 [v1]获取用户的未读互动消息接口", notes = "获取用户的未读互动消息接口")
    @ApiVersion(1)
    @GetMapping(value = "getUnReadInteract")
    public ResponseJson<InteractMessageDTO> getUnReadInteractMessage(InteractMessageParam param) {
        return ResponseJson.ok(userMessageService.getUnReadInteractMessage(param.getUserId()));
    }


    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", paramType = "query", dataType = "String", required = true),
            @ApiImplicitParam(name = "areaCode", value = "地区编码", paramType = "query", dataType = "String", required = true),
            @ApiImplicitParam(name = "type", value = "tab类型：0：评论，1：点赞", paramType = "query", dataType = "String", required = true)
    })
    @ApiOperation(value = "5-05-2 [v1]根据类型（点赞或评论）获取是否有未读消息", notes = "根据类型（点赞或评论）获取是否有未读消息")
    @ApiVersion(1)
    @GetMapping(value = "hasLatestMessage")
    public ResponseJson<Boolean> hasLatestMessage(@RequestParam(value = "userId") Long userId,
                                                  @RequestParam(value = "areaCode") String areaCode,
                                                  @RequestParam(value = "type") Byte type, BasicParam basicParam) {
        return ResponseJson.ok(userMessageService.hasLatestMessage(userId, areaCode, type, basicParam));
    }
}