/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.controller;

import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.SmsJson;
import com.bxm.localnews.mq.common.constant.SmsTemplateEnum;
import com.bxm.localnews.mq.common.model.dto.SendSmsResult;
import com.bxm.localnews.mq.common.model.dto.SmsSupplyDTO;
import com.bxm.localnews.msg.service.SmsSupplyService;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.tools.Validater;
import com.bxm.newidea.component.util.WebUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"5-02 \u77ed\u4fe1\u63a5\u53e3"}, description="\u77ed\u4fe1\u53d1\u9001\u4e0e\u9a8c\u8bc1\u63a5\u53e3")
@RestController
@RequestMapping(value={"api/sms"})
public class SmsController {
    @Resource
    private SmsSupplyService smsSupplyService;

    @ApiOperation(value="5-02-1\u53d1\u9001\u9a8c\u8bc1\u77ed\u4fe1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="\u77ed\u4fe1\u7c7b\u578b 1:\u767b\u5f55\uff08\u77ed\u4fe1\u767b\u5f55\u65b9\u5f0f\uff092\uff1a\u7ed1\u5b9a\u624b\u673a\u53f7\uff08app\u7ed1\u5b9a\u624b\u673a\u53f7\u7801\uff09 3\uff1a\u6ce8\u518c\uff08h5\u9875\u9762\u6ce8\u518c\u7528\u6237\uff09\uff0c6\uff1a\u5fd8\u8bb0\u5bc6\u7801\uff08app\u7aef\u5fd8\u8bb0\u5bc6\u7801\uff09,7:\u666e\u901a\u624b\u673a\u77ed\u4fe1\u9a8c\u8bc1\u7801\uff08\u84dd\u9886\uff0c\u5546\u6237\u4f7f\u7528\uff098: \u652f\u4ed8\u5b9d\u8d26\u6237\u7ed1\u5b9a9: \u5546\u5bb6\u63d0\u73b0\u9a8c\u8bc1\u7801"), @ApiImplicitParam(name="phone", value="\u63a5\u6536\u9a8c\u8bc1\u7801\u7684\u624b\u673a\u53f7\u7801")})
    @PostMapping(value={"/vcode"})
    public SmsJson getVerificationCode(Byte type, String phone, HttpServletRequest httpServletRequest) {
        if (type == null || StringUtils.isEmpty((CharSequence)phone)) {
            return SmsJson.build((Json)ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u53c2\u6570\u9519\u8bef"));
        }
        if (!Validater.checkPhone((String)phone)) {
            return SmsJson.build((Json)ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u624b\u673a\u53f7\u7801\u4e0d\u6b63\u786e"));
        }
        SmsTemplateEnum templateEnum = SmsTemplateEnum.getTemplateByType((Byte)type);
        if (templateEnum != null) {
            SmsSupplyDTO smsSupplyDTO = new SmsSupplyDTO();
            smsSupplyDTO.setPhoneNo(phone);
            smsSupplyDTO.setSmsTemplateEnum(templateEnum);
            smsSupplyDTO.setIp(WebUtils.getIpAddr((HttpServletRequest)httpServletRequest));
            SendSmsResult result = this.smsSupplyService.sendSmsByVCodeTemplate(phone, templateEnum, WebUtils.getIpAddr((HttpServletRequest)httpServletRequest));
            if (result.getState().booleanValue()) {
                return SmsJson.build((Json)ResultUtil.genFailedResult((int)0, (String)result.getMsg()));
            }
            return SmsJson.build((Json)ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)result.getMsg()));
        }
        return SmsJson.build((Json)ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u53c2\u6570\u9519\u8bef"));
    }

    @ApiOperation(value="5-02-2\u77ed\u4fe1\u9a8c\u8bc1\u7801\u68c0\u67e5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="\u77ed\u4fe1\u7c7b\u578b 1:\u767b\u5f55\uff08\u77ed\u4fe1\u767b\u5f55\u65b9\u5f0f\uff092\uff1a\u7ed1\u5b9a\u624b\u673a\u53f7\uff08app\u7ed1\u5b9a\u624b\u673a\u53f7\u7801\uff09 3\uff1a\u6ce8\u518c\uff08h5\u9875\u9762\u6ce8\u518c\u7528\u6237\uff09\uff0c6\uff1a\u5fd8\u8bb0\u5bc6\u7801\uff08app\u7aef\u5fd8\u8bb0\u5bc6\u7801\uff09,7:\u666e\u901a\u624b\u673a\u77ed\u4fe1\u9a8c\u8bc1\u7801\uff08\u84dd\u9886\uff0c\u5546\u6237\u4f7f\u7528\uff09"), @ApiImplicitParam(name="phone", value="\u63a5\u6536\u77ed\u4fe1\u7684\u624b\u673a\u53f7\u7801"), @ApiImplicitParam(name="code", value="\u7528\u6237\u586b\u5199\u7684\u9a8c\u8bc1\u7801")})
    @GetMapping(value={"/check"})
    public Json checkCode(Byte type, String phone, String code) {
        SmsTemplateEnum templateEnum = SmsTemplateEnum.getTemplateByType((Byte)type);
        boolean result = false;
        if (templateEnum != null) {
            result = this.smsSupplyService.verifySmsCode(phone, code, templateEnum);
        }
        if (result) {
            return ResultUtil.genFailedResult((int)0, (String)"\u9a8c\u8bc1\u901a\u8fc7");
        }
        return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u9a8c\u8bc1\u5931\u8d25");
    }

    @ApiOperation(value="5-02-3\u53d1\u9001\u81ea\u5b9a\u4e49\u77ed\u4fe1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u81ea\u5b9a\u4e49\u77ed\u4fe1\u5185\u5bb9"), @ApiImplicitParam(name="phone", value="\u63a5\u6536\u9a8c\u8bc1\u7801\u7684\u624b\u673a\u53f7\u7801")})
    @PostMapping(value={"/custom"})
    public SmsJson sendCustomSms(String content, String phone) {
        if (StringUtils.isBlank((CharSequence)content) || !Validater.checkPhone((String)phone)) {
            return SmsJson.build((Json)ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u53c2\u6570\u9519\u8bef"));
        }
        SmsSupplyDTO smsSupplyDTO = new SmsSupplyDTO();
        smsSupplyDTO.setPhoneNo(phone);
        smsSupplyDTO.setContent(content);
        SendSmsResult result = this.smsSupplyService.sendSmsByCustomize(phone, content);
        int respCode = 0;
        if (!result.getState().booleanValue()) {
            respCode = RespCode.BAD_REQUEST;
        }
        return SmsJson.build((Json)ResultUtil.genFailedResult((int)respCode, (String)result.getMsg()));
    }
}

