/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.msg.dto.MessageNumDTO;
import com.bxm.localnews.msg.dto.MessageTypeDTO;
import com.bxm.localnews.msg.param.MessageListParam;
import com.bxm.localnews.msg.service.UserMessageService;
import com.bxm.localnews.msg.vo.UserMessageBean;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"5-01 \u7528\u6237\u6d88\u606f\u5217\u8868"}, description="\u7528\u6237\u6d88\u606f\u4e2d\u5fc3\u76f8\u5173\u670d\u52a1")
@RestController
@RequestMapping(value={"api/msg"})
public class MessageController {
    private static final Logger log = LoggerFactory.getLogger(MessageController.class);
    @Resource
    private UserMessageService userMessageService;

    @ApiOperation(value="5-01-1 \u6839\u636e\u7c7b\u578b\u83b7\u53d6\u7528\u6237\u6d88\u606f\u5217\u8868", notes="\u6839\u636emsgType\u83b7\u53d6\u6240\u6709\u7684\u6d88\u606f\u5217\u8868,type:INTERACTION(\u4e92\u52a8\u6d88\u606f)\u3001SYSTEM(\u7cfb\u7edf\u901a\u77e5)\u3001NEWS(\u70ed\u95fb)\u3001BALANCE(\u4f59\u989d)\u3001COMMENT(\u8bc4\u8bba)\u3001LIKE(\u70b9\u8d5e)\u3001SHARE(\u5206\u4eab)\u3001INVITE(\u9080\u8bf7)")
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true)
    @GetMapping(value={"list"})
    public Json<PageWarper<UserMessageBean>> getList(@Validated MessageListParam messageListParam, BasicParam basicParam) {
        return Json.build((Object)this.userMessageService.listMessage(messageListParam, basicParam));
    }

    @ApiOperation(value="5-01-7 [\u5e9f\u5f03]\u83b7\u53d6\u6d88\u606f\u7c7b\u578b\u53ca\u5176\u5e7f\u544a\u5217\u8868", notes="\u4f7f\u75285-04-1\u63a5\u53e3\u4ee3\u66ff")
    @ApiImplicitParams(value={@ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="userId", value="\u7528\u6237id", paramType="query", dataType="String")})
    @GetMapping(value={"type"})
    @Deprecated
    public Json<MessageTypeDTO> getMessageTypes(@RequestParam(value="areaCode") String areaCode, @RequestParam(value="userId") Long userId, BasicParam basicParam) {
        return ResultUtil.genSuccessResult((Object)this.userMessageService.getMessageType(areaCode, userId, basicParam));
    }

    @ApiOperation(value="5-01-2 \u83b7\u53d6\u6700\u65b0\u6d88\u606f\u6761\u6570")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true), @ApiImplicitParam(name="platform", value="\u5e73\u53f0\u7c7b\u578b", required=true), @ApiImplicitParam(name="curVer", value="\u5f53\u524d\u5ba2\u6237\u7aef\u7248\u672c")})
    @GetMapping(value={"newMsg"})
    public Json<MessageNumDTO> getNewMsg(@RequestParam(value="userId") Long userId, @RequestParam(value="platform") Integer platform, @RequestParam(value="curVer") String curVer) {
        int num = this.userMessageService.getUnReadMsg(userId, platform, curVer);
        MessageNumDTO messageNumDTO = new MessageNumDTO();
        messageNumDTO.setNum(num);
        return ResultUtil.genSuccessResult((Object)messageNumDTO);
    }

    @ApiOperation(value="5-01-3 \u6e05\u7a7a\u6d88\u606f")
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true)
    @GetMapping(value={"delete"})
    public Json updateById(@RequestParam(value="userId") Long userId) {
        return Json.build();
    }

    @ApiOperation(value="5-01-4 \u66f4\u65b0\u6d88\u606f\u4e3a\u5df2\u8bfb", notes="\u5c06\u6d88\u606f\u7c7b\u76ee\u6216\u4f1a\u8bdd\u7684\u672a\u8bfb\u6d88\u606f\u6570\u91cf\u8bbe\u7f6e\u4e3a0")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true), @ApiImplicitParam(name="id", value="\u6d88\u606fid[\u5df2\u5e9f\u5f03\uff0c\u4e0d\u9700\u8981\u4f20\u9012]"), @ApiImplicitParam(name="status", value="\u72b6\u6001\u503c[\u5df2\u5e9f\u5f03\uff0c\u4e0d\u9700\u8981\u4f20\u9012]"), @ApiImplicitParam(name="messageType", value="\u6d88\u606f\u7c7b\u578b\u6216\u4f1a\u8bddID\uff0c\u6d88\u606f\u7c7b\u578b\uff1aINTERACTION(\u4e92\u52a8\u6d88\u606f)\u3001SYSTEM(\u7cfb\u7edf\u901a\u77e5)\u3001NEWS(\u70ed\u95fb)\u3001BALANCE(\u4f59\u989d)\u3001COMMENT(\u8bc4\u8bba)\u3001LIKE(\u70b9\u8d5e)\u3001SHARE(\u5206\u4eab)\u3001INVITE(\u9080\u8bf7)", required=true)})
    @GetMapping(value={"read/delete"})
    public Json updateById(@RequestParam(value="userId") Long userId, @RequestParam(value="id", required=false) Integer id, @RequestParam(value="status", required=false) Byte status, @RequestParam(value="messageType", required=false) String messageType) {
        if (null == userId || StringUtils.isBlank((CharSequence)messageType)) {
            log.info("\u8bf7\u6c42\u53c2\u6570\u4e0d\u5b8c\u6574\uff0c\u7f3a\u5c11\u7528\u6237ID\u6216\u6d88\u606f\u7c7b\u578b");
            return Json.build();
        }
        this.userMessageService.updateMessageByType(userId, messageType);
        return Json.build();
    }

    @ApiOperation(value="5-01-5 \u516c\u544a\u5217\u8868(\u5df2\u5e9f\u5f03)", hidden=true)
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true)
    @GetMapping(value={"notice/list"})
    @Deprecated
    public Json<List<UserMessageBean>> notices(@RequestParam(value="userId", required=false) Long userId, MPage page) {
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value="5-01-6 \u516c\u544a\u8be6\u60c5(\u5df2\u5e9f\u5f03)", hidden=true)
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true), @ApiImplicitParam(name="id", value="\u6d88\u606fid", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true), @ApiImplicitParam(name="messageType", value="\u6d88\u606f\u7c7b\u578b")})
    @GetMapping(value={"notice/detail"})
    @Deprecated
    public Json<UserMessageBean> noticeDetail(@RequestParam(value="id", required=false) Integer id, @RequestParam(value="userId", required=false) Long userId, @RequestParam(value="messageType", required=false) String messageType) {
        return ResultUtil.genSuccessResult();
    }
}

