/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.controller;

import com.bxm.localnews.common.param.PointReportParam;
import com.bxm.localnews.mq.common.constant.PlatformTypeEnum;
import com.bxm.localnews.msg.integration.BizLogIntegrationService;
import com.bxm.localnews.msg.service.MessageGroupCounterService;
import com.bxm.localnews.msg.service.MessageGroupService;
import com.bxm.localnews.msg.service.UserTokenService;
import com.bxm.localnews.msg.vo.MsgGroupPushCounterBean;
import com.bxm.localnews.msg.vo.MsgUserTokenBean;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"5-03 \u7528\u6237\u6d88\u606f\u5217\u8868"}, description="\u63a8\u9001\u6d88\u606f\u540e\u7684\u76f8\u5173\u56de\u8c03\u64cd\u4f5c")
@RestController
@RequestMapping(value={"api/public/push/message"})
public class PushMessageController {
    private static final Logger log = LoggerFactory.getLogger(PushMessageController.class);
    private final MessageGroupCounterService messageGroupCounterService;
    private final UserTokenService userTokenService;
    private final BizLogIntegrationService bizLogIntegrationService;
    private MessageGroupService messageGroupService;

    @Autowired
    public PushMessageController(MessageGroupCounterService messageGroupCounterService, UserTokenService userTokenService, BizLogIntegrationService bizLogIntegrationService) {
        this.messageGroupCounterService = messageGroupCounterService;
        this.userTokenService = userTokenService;
        this.bizLogIntegrationService = bizLogIntegrationService;
    }

    private MessageGroupService getMessageGroupService() {
        if (null == this.messageGroupService) {
            this.messageGroupService = (MessageGroupService)SpringContextHolder.getBean(MessageGroupService.class);
        }
        return this.messageGroupService;
    }

    @ApiOperation(value="5-03-1 \u66f4\u65b0\u7528\u6237\u67e5\u9605\u6d88\u606f\u540e\u7684\u72b6\u6001", notes="\u7528\u6237\u67e5\u770b\u63a8\u9001\u6d88\u606f\u540e\u53cd\u9988\u67e5\u770b\u7ed3\u679c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true), @ApiImplicitParam(name="messageId", value="\u6d88\u606fid", required=true)})
    @PostMapping(value={"checked"})
    public ResponseJson updateById(@RequestParam(value="userId") Long userId, @RequestParam(value="messageId") Long messageId) {
        if (this.getMessageGroupService().isGroupMsg(messageId)) {
            List userToken = this.userTokenService.loadToken(userId);
            boolean hit = false;
            for (MsgUserTokenBean tokenBean : userToken) {
                PlatformTypeEnum platform = PlatformTypeEnum.getByCode((byte)tokenBean.getType());
                if (!platform.isApp()) continue;
                hit = true;
                this.messageGroupCounterService.addCounter(MsgGroupPushCounterBean.builder().callback(Integer.valueOf(1)).groupMsgId(messageId).pushType(Byte.valueOf(platform.getCode())).build());
                PointReportParam reportParam = PointReportParam.build().e("3034").ev("126").put("uid", String.valueOf(tokenBean.getUserId())).put("nid", String.valueOf(messageId)).put("type", String.valueOf(tokenBean.getPlatform())).put("num", "2");
                this.bizLogIntegrationService.point(reportParam);
            }
            if (!hit) {
                log.info("\u7528\u6237[{}]\u70b9\u51fb\u6d88\u606f\u56de\u8c03\u65f6\u627e\u4e0d\u5230\u5bf9\u5e94\u7684token\uff0c\u6d88\u606fID\u4e3a[{}]", (Object)userId, (Object)messageId);
            }
        } else {
            log.info("\u975e\u8fd0\u8425\u6d88\u606f\u70b9\u51fb\u56de\u8c03\uff0cuserId:{},messageId:{}", (Object)userId, (Object)messageId);
        }
        return ResponseJson.ok().build();
    }
}

