package com.bxm.localnews.msg.facade;

import com.bxm.localnews.mq.common.param.DingtalkMessage;
import com.bxm.localnews.msg.facade.fallback.DingtalkFallbackFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 钉钉推送接口封装
 *
 * @author liujia
 * @date 2020-07-13 17:39
 **/
@Api(tags = "5-92 [内部]钉钉消息推送")
@FeignClient(value = "localnews-msg", fallbackFactory = DingtalkFallbackFactory.class, primary = false)
public interface DingtalkFacadeService {

    @ApiOperation(value = "5-92-3 通用钉钉消息推送")
    @PostMapping("facade/message/dingtalk")
    void pushDingtalk(@RequestBody DingtalkMessage message);
}
