package com.bxm.localnews.msg.facade;

import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.facade.fallback.PushFallbackFactory;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * 消息模块的facade接口对应feign调用
 *
 * @author liujia
 * @date 2020-07-13 16:37
 **/
@FeignClient(value = "localnews-msg", fallbackFactory = PushFallbackFactory.class, primary = false)
@RequestMapping("/facade/message")
public interface PushFacadeService {

    @ApiOperation(value = "5-99-1 推送消息到客户端")
    @PostMapping("push")
    void pushMsg(@RequestBody PushMessage message);
}
