package com.bxm.localnews.msg.facade;

import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.msg.facade.fallback.UserEventFallbackFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * 用户事件内部接口调用
 *
 * @author liujia
 * @date 2020-07-13 16:46
 **/
@Api(tags = "5-94 [内部]用户事件定义")
@FeignClient(value = "localnews-msg", fallbackFactory = UserEventFallbackFactory.class, primary = false)
@RequestMapping("/facade/user/event")
public interface UserEventFacadeService {

    @ApiOperation(value = "5-94-1 添加用户事件，扩展信息中必须包含userId")
    @PostMapping("add")
    void add(@RequestBody PushPayloadInfo payloadInfo);
}
