package com.bxm.localnews.msg.facade.fallback;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.mq.common.model.dto.SendSmsResult;
import com.bxm.localnews.mq.common.model.dto.SmsSupplyDTO;
import com.bxm.localnews.msg.facade.SmsFacadeService;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 短信发送失败的处理逻辑
 *
 * @author liujia
 * @date 2020-07-15 22:22
 **/
@Component
@Slf4j
public class SmsFallbackFactory implements FallbackFactory<SmsFacadeService> {
    @Override
    public SmsFacadeService create(Throwable cause) {
        return new SmsFacadeService() {
            @Override
            public Boolean verifySmsCodeByType(Byte type, String phoneNo, String code) {
                log.error("短信有效性验证失败，type:{},phoneNo:{},code:{}",
                        type,
                        phoneNo,
                        code);
                log.error(cause.getMessage(), cause);

                return Boolean.FALSE;
            }

            @Override
            public SendSmsResult sendSmsByVCodeTemplate(SmsSupplyDTO smsSupplyDTO) {
                log.error("短信发送失败，短信内容：{}", JSON.toJSONString(smsSupplyDTO));
                log.error(cause.getMessage(), cause);

                SendSmsResult result = new SendSmsResult();
                result.setState(Boolean.FALSE);
                return result;
            }
        };
    }
}
