package com.bxm.localnews.msg.integration;

import com.bxm.localnews.mq.common.model.dto.SendSmsResult;
import com.bxm.localnews.mq.common.model.dto.SmsSupplyDTO;
import com.bxm.localnews.msg.facade.SmsFacadeService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * 短消息集成服务
 *
 * @author liujia
 * @date 2020-07-15 22:31
 **/
@Service
@Slf4j
public class SmsIntegrationService {

    @Resource
    private SmsFacadeService smsFacadeService;

    /**
     * 判断验证码是否正确
     *
     * @param type    验证码类型
     * @param phoneNo 手机号码
     * @param code    用户输入的验证码
     * @return true 表示验证通过
     */
    public Boolean verifyByType(Byte type, String phoneNo, String code) {
        try {
            return smsFacadeService.verifySmsCodeByType(type, phoneNo, code);
        } catch(Exception e) {
            log.error("调用msg服务校验验证失败 type: {}, phoneNo: {}, code: {}", type, phoneNo, code, e);
        }
        return Boolean.FALSE;
    }

    /**
     * 自定义短信参数发送短信
     *
     * @param param 短信发送参数
     * @return 短信发送结果
     */
    public SendSmsResult sendSMS(SmsSupplyDTO param) {
        return smsFacadeService.sendSmsByVCodeTemplate(param);
    }
}
