/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.sender;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.mq.common.model.dto.MessageFilterInfo;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.param.DingtalkMessage;
import com.bxm.localnews.msg.facade.DingtalkFacadeService;
import com.bxm.localnews.msg.facade.MessageFacadeService;
import com.bxm.localnews.msg.facade.PushFacadeService;
import com.bxm.localnews.msg.facade.UserEventFacadeService;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class MessageSender {
    private static final Logger log = LoggerFactory.getLogger(MessageSender.class);
    private final ThreadPoolTaskExecutor asyncTheadPoolExecutor;
    private final PushFacadeService pushFacadeService;
    private final UserEventFacadeService userEventFacadeService;
    private final MessageFacadeService messageFacadeService;
    private final DingtalkFacadeService dingtalkFacadeService;

    @Autowired
    public MessageSender(ThreadPoolTaskExecutor asyncTheadPoolExecutor, PushFacadeService pushFacadeService, UserEventFacadeService userEventFacadeService, MessageFacadeService messageFacadeService, DingtalkFacadeService dingtalkFacadeService) {
        this.asyncTheadPoolExecutor = asyncTheadPoolExecutor;
        this.pushFacadeService = pushFacadeService;
        this.userEventFacadeService = userEventFacadeService;
        this.messageFacadeService = messageFacadeService;
        this.dingtalkFacadeService = dingtalkFacadeService;
    }

    public void sendPushMessage(PushMessage message) {
        if (null == message) {
            return;
        }
        this.asyncTheadPoolExecutor.execute(() -> this.pushFacadeService.pushMsg(message));
    }

    public void sendUserMessage(PushMessage message) {
        if (null == message) {
            return;
        }
        if (message.getPushReceiveScope() == null || message.getPushReceiveScope().getUserId() == null) {
            log.info("\u6d88\u606f\u63a5\u6536\u4eba\u4e3a\u7a7a\uff0c\u4e0d\u4e88\u5904\u7406\uff0c\u6d88\u606f\u5185\u5bb9\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)message));
        }
        this.asyncTheadPoolExecutor.execute(() -> {
            Long userId = message.getPushReceiveScope().getUserId();
            this.messageFacadeService.addMsg(message, userId);
        });
    }

    public void sendUserEvent(PushPayloadInfo payloadInfo) {
        if (null == payloadInfo || payloadInfo.getTargetUserId() == null) {
            log.warn("\u7528\u6237\u4e8b\u4ef6\u5bf9\u8c61\u4e0d\u5b58\u5728\u6216\u8005\u63a5\u6536\u7528\u6237ID\u4e3a\u7a7a\uff0c\u8f7d\u4f53\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)payloadInfo));
            return;
        }
        this.asyncTheadPoolExecutor.execute(() -> this.userEventFacadeService.add(payloadInfo));
    }

    public void sendMsgFilterEvent(MessageFilterInfo info) {
        if (Objects.isNull(info)) {
            log.warn("\u7528\u6237\u4e0a\u62a5\u7684\u6d88\u606f\u53ec\u56de\u4fe1\u606f\u6709\u8bef  : {}", (Object)JSON.toJSONString((Object)info));
        }
        this.asyncTheadPoolExecutor.execute(() -> this.messageFacadeService.addMsgFilter(info));
    }

    public void sendDingtalk(DingtalkMessage message) {
        if (null == message || StringUtils.isBlank((String)message.getContent())) {
            log.warn("\u9489\u9489\u63a8\u9001\u6d88\u606f\u4e3a\u7a7a\u6216\u5185\u5bb9\u4e3a\u7a7a");
            return;
        }
        this.asyncTheadPoolExecutor.execute(() -> this.dingtalkFacadeService.pushDingtalk(message));
    }
}

