package com.bxm.localnews.msg.facade;

import com.bxm.localnews.mq.common.model.dto.UserTokenParam;
import com.bxm.localnews.msg.facade.fallback.UserEventFallbackFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * @author liujia
 * @date 2020-07-14 21:16
 **/
@Api(tags = "5-91 [内部]用户token内部接口", description = "用户推送相关的token上报")
@FeignClient(value = "localnews-msg", fallbackFactory = UserEventFallbackFactory.class, primary = false)
@RequestMapping("/facade/msg/user/token")
public interface UserTokenFacadeService {

    @ApiOperation(value = "5-91 新增用户token")
    @PostMapping("add")
    void addToken(@RequestBody UserTokenParam param);
}
