package com.bxm.localnews.mq.facade.controller;

import com.bxm.localnews.mq.dingtalk.service.DingtalkPushService;
import com.bxm.newidea.component.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "1-1 钉钉消息推送")
@RestController
@RequestMapping("dingtalk")
public class DingtalkPushController extends BaseController {

    private final DingtalkPushService dingtalkPushService;

    @Autowired
    public DingtalkPushController(DingtalkPushService dingtalkPushService) {
        this.dingtalkPushService = dingtalkPushService;
    }

    @ApiOperation(value = "1-1-1 推送钉钉消息到新闻监控群")
    @ApiImplicitParam(name = "content", value = "推送内容")
    @PostMapping("news")
    void pushNewsGroup(@RequestBody String content) {
        logger.debug("request content:[{}]", content);
        dingtalkPushService.pushNews(content);
    }
}
