package com.bxm.localnews.mq.facade.controller;

import com.bxm.localnews.mq.produce.service.NewsStatisticService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Api(tags = "1-5 新闻静态数据变更")
@RestController
@RequestMapping("/facade/news/statistic")
public class NewsStatisticController {

    @Autowired
    private NewsStatisticService newsStatisticService;

    @ApiOperation(value = "1-5-1 推送分享数据到消息队列")
    @PostMapping("/share")
    public void pushShareData(@RequestParam(value = "userId") Long userId,
                              @RequestParam(value = "newsId") Long newsId) {
        newsStatisticService.pushShareData(newsId, userId);
    }

    @ApiOperation(value = "1-5-2 推送阅读数据到消息队列")
    @PostMapping("/view")
    public void pushViewData(@RequestParam(value = "userId") Long userId,
                             @RequestParam(value = "newsId") Long newsId) {
        newsStatisticService.pushViewData(newsId, userId);
    }

    @ApiOperation(value = "1-5-3 推送推荐数据到消息队列")
    @PostMapping("/recommended")
    public void pushRecommededData(@RequestParam(value = "userId") Long userId,
                                   @RequestParam(value = "newsIds") String newsIds) {
        newsStatisticService.pushRecommededData(newsIds, userId);
    }

    @ApiOperation(value = "1-5-4 推送点击数据到消息队列")
    @PostMapping("/newClick")
    public void pushNewClickData(@RequestParam(value = "userId") Long userId,
                                 @RequestParam(value = "newsId") Long newsId) {
        newsStatisticService.pushNewClickData(newsId, userId);
    }

    @ApiOperation(value = "1-5-5 推送收藏数据到消息队列")
    @PostMapping("/collect")
    public void pushCollectData(@RequestParam(value = "userId") Long userId,
                                @RequestParam(value = "newsId") Long newsId,
                                @RequestParam(value = "type") Byte type) {
        newsStatisticService.pushCollectData(newsId, userId, type);
    }

    @ApiOperation(value = "1-5-6 推送评论数据到消息队列")
    @PostMapping("/comment")
    public void pushCommentData(@RequestParam(value = "userId") Long userId,
                                @RequestParam(value = "newsId") Long newsId) {
        newsStatisticService.pushCommentData(newsId, userId);
    }


}
