package com.bxm.localnews.mq.facade.controller;

import com.bxm.localnews.mq.produce.service.VideoStatisticService;
import com.bxm.localnews.msg.param.VideoBlackParam;
import com.bxm.localnews.msg.param.VideoShareParam;
import com.bxm.localnews.msg.param.VideoViewParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(tags = "4-92 小视频静态数据变更", description = "包括屏蔽、分享、浏览、评论")
@RestController
@RequestMapping("facade/video/statistic")
public class VideoStatisticController {

    @Autowired
    VideoStatisticService videoStatisticService;

    @ApiOperation(value = "4-92-1 推送小视频屏蔽到消息队列", notes = "")
    @PostMapping("black")
    public void videoBlackConsume(@RequestBody VideoBlackParam videoBlackParam) {
        videoStatisticService.pushVideoBlackData(videoBlackParam);
    }

    @ApiOperation(value = "4-92-2 推送小视频分享消息队列", notes = "")
    @PostMapping("share")
    public void videoShareConsume(@RequestBody VideoShareParam videoShareParam) {
        videoStatisticService.pushShareData(videoShareParam);
    }

    @ApiOperation(value = "4-92-3 推送小视频浏览消息队列", notes = "")
    @PostMapping("view")
    public void videoViewConsume(@RequestBody VideoViewParam videoViewParam) {
        videoStatisticService.pushViewData(videoViewParam);
    }

    @ApiOperation(value = "4-92-4 推送小视频评论消息队列", notes = "")
    @PostMapping("comment")
    public void videoCommentConsume(@RequestParam("userId") Long userId,
                                    @RequestParam(value = "newsId")Long newsId) {
        videoStatisticService.pushCommentData(userId,newsId);
    }


}
