package com.bxm.localnews.msg.facade;

import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.facade.fallback.PushTemplateMessageFallbackFactory;
import com.bxm.newidea.component.vo.Message;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author zhaoyadong 2019/6/12 15:50
 * @desc
 */
@FeignClient(value = "localnews", fallbackFactory = PushTemplateMessageFallbackFactory.class, primary = false)
public interface PushTemplateMessageFeignService {

    @PostMapping("/facade/template/push")
    ResponseEntity<Message> pushTemplateMessage(@RequestBody PushMessage pushMessage,
                                                @RequestParam(value = "appId", required = false) String appId);
}
