package com.bxm.localnews.msg.integration;

import com.bxm.localnews.msg.facade.UserFacadeService;
import com.bxm.localnews.mq.common.param.UserSearchPageParam;
import com.bxm.localnews.msg.vo.UserInfoBean;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

/**
 * 用户服务调用封装
 *
 * @author liujia
 */
@Service
public class UserIntegrationService {

    private final UserFacadeService userFacadeService;

    @Autowired
    public UserIntegrationService(UserFacadeService userFacadeService) {
        this.userFacadeService = userFacadeService;
    }

    /**
     * 获取用户信息
     * 尝试从缓存获取，如果获取为空，尝试调用用户服务接口
     *
     * @param userId 用户ID
     * @return 用户信息
     */
    public UserInfoBean getUserInfo(Long userId) {
        ResponseEntity<UserInfoBean> response = userFacadeService.getUserInfo(userId);
        if (response.hasBody()) {
            return response.getBody();
        }
        return null;
    }

    /**
     * 分页获取符合条件的用户信息
     *
     * @param param 查询参数，根据推送执行的圈定范围进行检索
     * @return 分页结果
     */
    public PageWarper<Long> queryUserByPage(UserSearchPageParam param) {
        ResponseEntity<PageWarper<Long>> response = userFacadeService.getUserByPage(param);
        if (response.hasBody()) {
            return response.getBody();
        }

        return new PageWarper<>(Lists.newArrayList());
    }
}
