package com.bxm.localnews.mq.config;

import java.util.Properties;

import javax.annotation.Resource;

import com.aliyun.openservices.ons.api.PropertyKeyConst;
import com.aliyun.openservices.ons.api.bean.ProducerBean;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

/**
 * 阿里云消息队列配置
 *
 * @author liujia 2018/7/27 14:25
 */
@Component
@Configuration
@ConditionalOnProperty(prefix = "aliyun.mq", value = "access-key")
@EnableConfigurationProperties(AliyunMqProperties.class)
//@Profile({"test", "prod"})
public class AliyunMqProduceConfiguration {

    @Resource
    private AliyunMqProperties aliyunMqProperties;

    @Bean(name = "producer", initMethod = "start", destroyMethod = "shutdown")
    public ProducerBean producerBean() {
        ProducerBean producerBean = new ProducerBean();

        Properties properties = new Properties();
        properties.setProperty(PropertyKeyConst.ProducerId, this.aliyunMqProperties.getProducerId());
        properties.setProperty(PropertyKeyConst.AccessKey, this.aliyunMqProperties.getAccessKey());
        properties.setProperty(PropertyKeyConst.SecretKey, this.aliyunMqProperties.getAccessSecret());

        producerBean.setProperties(properties);

        return producerBean;
    }

    @Bean(name = "mpProducer", initMethod = "start", destroyMethod = "shutdown")
    public ProducerBean mpProducer() {
        ProducerBean producerBean = new ProducerBean();

        Properties properties = new Properties();
        properties.setProperty(PropertyKeyConst.ProducerId, this.aliyunMqProperties.getMpProducerId());
        properties.setProperty(PropertyKeyConst.AccessKey, this.aliyunMqProperties.getAccessKey());
        properties.setProperty(PropertyKeyConst.SecretKey, this.aliyunMqProperties.getAccessSecret());

        producerBean.setProperties(properties);

        return producerBean;
    }

    /**
     * 短信生产者
     *
     * @return
     */
    @Bean(name = "smsProducer", initMethod = "start", destroyMethod = "shutdown")
    public ProducerBean smsProducer() {
        ProducerBean producerBean = new ProducerBean();

        Properties properties = new Properties();
        properties.setProperty(PropertyKeyConst.ProducerId, this.aliyunMqProperties.getSmsProducerId());
        properties.setProperty(PropertyKeyConst.AccessKey, this.aliyunMqProperties.getAccessKey());
        properties.setProperty(PropertyKeyConst.SecretKey, this.aliyunMqProperties.getAccessSecret());

        producerBean.setProperties(properties);

        return producerBean;
    }

    /**
     * 推送消息生产者
     *
     * @return
     */
    @Bean(name = "pushProducer", initMethod = "start", destroyMethod = "shutdown")
    public ProducerBean pushProducer() {
        ProducerBean producerBean = new ProducerBean();

        Properties properties = new Properties();
        properties.setProperty(PropertyKeyConst.ProducerId, this.aliyunMqProperties.getPushProducerId());
        properties.setProperty(PropertyKeyConst.AccessKey, this.aliyunMqProperties.getAccessKey());
        properties.setProperty(PropertyKeyConst.SecretKey, this.aliyunMqProperties.getAccessSecret());

        producerBean.setProperties(properties);

        return producerBean;
    }

    /**
     * 新闻消息生产者
     *
     * @return
     */
    @Bean(name = "newsProducer", initMethod = "start", destroyMethod = "shutdown")
    public ProducerBean newsProducer() {
        ProducerBean producerBean = new ProducerBean();

        Properties properties = new Properties();
        properties.put(PropertyKeyConst.GROUP_ID, this.aliyunMqProperties.getNewsGroupId());
        properties.setProperty(PropertyKeyConst.AccessKey, this.aliyunMqProperties.getAccessKey());
        properties.setProperty(PropertyKeyConst.SecretKey, this.aliyunMqProperties.getAccessSecret());

        producerBean.setProperties(properties);

        return producerBean;
    }
}
