package com.bxm.localnews.mq.consume.consumer.impl;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.bxm.component.mybatis.utils.BatchHelper;
import com.bxm.localnews.mq.common.constant.MQConstant;
import com.bxm.localnews.mq.consume.consumer.TagMessageConsumer;
import com.bxm.localnews.msg.domain.NewsStatisticsConsumeMapper;
import com.bxm.newidea.component.tools.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

import static com.bxm.localnews.mq.common.constant.MQConstant.TAG.NEWS_RECOMMENDED;

/**
 * 新闻推荐消息消费
 * 当给用户推荐新闻、视频后，统计推荐相关数据
 * @author liujia 2018/8/21 14:50
 */
@Component
public class NewsRecommendTagConsumer implements TagMessageConsumer {

    private static final Logger LOGGER = LoggerFactory.getLogger(NewsRecommendTagConsumer.class);

    @Resource
    private NewsStatisticsConsumeMapper newsStatisticsConsumeMapper;

    @Override
    public boolean support(String tag) {
        return NEWS_RECOMMENDED.equals(tag);
    }

    @Override
    public Action consume(Message message, ConsumeContext context) {
        try {
            this.newsRecommended(message);
        } catch (Exception e) {
            LOGGER.warn(e.getMessage(), e);
            return Action.ReconsumeLater;
        }
        LOGGER.debug("消费成功，消息内容：" + message);
        return Action.CommitMessage;
    }

    private void newsRecommended(Message message) {
        Long userId = Long.valueOf(message.getUserProperties(MQConstant.NEWS_KEY.USER_ID));
        String newsIds = message.getUserProperties(MQConstant.NEWS_KEY.REMENDED_IDS);
        String[] newsIdArray = StringUtils.split(newsIds, ",");
        //推荐次数+1
        new BatchHelper<NewsStatisticsConsumeMapper, String>(NewsStatisticsConsumeMapper.class, newsIdArray) {

            @Override
            protected int invoke(String element) {
                return this.mapper.recommended(Long.valueOf(element));
            }
        };
    }

}
