package com.bxm.localnews.mq.consume.consumer.impl;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.bxm.localnews.mq.common.constant.MQConstant;
import com.bxm.localnews.mq.consume.consumer.TagMessageConsumer;
import com.bxm.localnews.mq.consume.integration.NewsSyncFeignService;
import com.bxm.localnews.mq.consume.param.NewsRecommended;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import static com.bxm.localnews.mq.common.constant.MQConstant.TAG.RECOMMENDED_KEY;

@Component
public class NewsRecommendedConsumer implements TagMessageConsumer {

    private static final Logger LOGGER = LoggerFactory.getLogger(NewsShareConsumer.class);

    @Autowired
    NewsSyncFeignService newsSyncFeignService;

    @Override
    public boolean support(String tag) {
        return RECOMMENDED_KEY.equals(tag);
    }

    @Override
    public Action consume(Message message, ConsumeContext context) {
        try {
            this.newsRecommend(message);
        } catch (Exception e) {
            LOGGER.warn(e.getMessage(), e);
            return Action.ReconsumeLater;
        }
        LOGGER.debug("消费成功，消息内容：" + message);
        return Action.CommitMessage;
    }

    private void newsRecommend(Message message) {
        Long userId = Long.valueOf(message.getUserProperties(MQConstant.NEW_CLICK_KEY.USER_ID));
        String newsIds = message.getUserProperties(MQConstant.NEW_CLICK_KEY.NEWS_ID);
        List<String> lis = Arrays.asList(newsIds.split(","));
        List<Long> newsIdList = lis.stream().map(Long::valueOf).collect(Collectors.toList());

        List<NewsRecommended> newsRecommendedList = new ArrayList<>();
        for (Long id : newsIdList) {
            NewsRecommended newsRecommended = new NewsRecommended();
            newsRecommended.setUserId(userId);
            newsRecommended.setNewsId(id);
            newsRecommendedList.add(newsRecommended);
        }

        newsSyncFeignService.saveRecommended(newsRecommendedList);
    }

}
