package com.bxm.localnews.mq.consume.consumer.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.bxm.localnews.mq.common.constant.MQConstant;
import com.bxm.localnews.mq.consume.integration.NewsFeignService;
import com.bxm.localnews.mq.consume.integration.NewsSyncFeignService;
import com.bxm.localnews.mq.consume.param.NewsStatistics;
import com.bxm.localnews.msg.param.VideoShareParam;
import com.bxm.localnews.msg.param.VideoViewParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

import static com.bxm.localnews.mq.common.constant.MQConstant.TAG.*;

@Component
public class VideoViewConsumer extends AbstractNewsActionMessageConsumer {

    private static final Logger LOGGER = LoggerFactory.getLogger(VideoViewConsumer.class);

    @Autowired
    NewsFeignService newsFeignService;


    @Override
    public boolean support(String tag) {
        return VIDEO_VIEW_KEY.equals(tag);
    }

    @Override
    public Action consume(Message message, ConsumeContext context) {
        try {
            this.newsViews(message);
        } catch (Exception e) {
            LOGGER.warn(e.getMessage(), e);
            return Action.ReconsumeLater;
        }
        LOGGER.debug("小视频阅读消费成功，消息内容：" + message);
        return Action.CommitMessage;
    }

    private void newsViews(Message message) {
        JSONObject body = getMsgBody(message);
        VideoViewParam videoViewParam = JSON.toJavaObject(body, VideoViewParam.class);

        newsFeignService.videoViewConsume(videoViewParam);
    }

}
