package com.bxm.localnews.mq.consume.push.receive;

import java.util.Map;

import com.bxm.localnews.mq.common.constant.PushReceiverRuleEnum;
import com.bxm.localnews.mq.consume.push.receive.impl.*;
import com.bxm.localnews.msg.domain.UserDeviceMapper;
import com.google.common.collect.Maps;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

/**
 * 构建用户获取迭代器对象
 */
@Component
public class ReceiveUserFactory implements ApplicationListener<ContextRefreshedEvent>, ApplicationContextAware {

    private final UserDeviceMapper userDeviceMapper;

    private ApplicationContext applicationContext;

    private Map<PushReceiverRuleEnum, IReceiveUserIterator> iteratorMap;

    @Autowired
    public ReceiveUserFactory(UserDeviceMapper userDeviceMapper) {
        this.userDeviceMapper = userDeviceMapper;
    }

    public IReceiveUserIterator get(PushReceiverRuleEnum rule, Map<String, Object> paramMap) {
        return iteratorMap.get(rule).build(paramMap).setUserDeviceMapper(userDeviceMapper);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        iteratorMap = Maps.newHashMap();
        iteratorMap.put(PushReceiverRuleEnum.DEFAULT, new DefaultUserReceiveUserIterator());
        iteratorMap.put(PushReceiverRuleEnum.AREA, new AreaReceiveUserIterator());
        iteratorMap.put(PushReceiverRuleEnum.ALL, new AllReceiveUserIterator());
        iteratorMap.put(PushReceiverRuleEnum.VIP_AREA, new AreaVipReceiveUserIterator());
        iteratorMap.put(PushReceiverRuleEnum.VIP_USER, new UserVipReceiveUserIterator());
    }
}
