package com.bxm.localnews.mq.consume.push.receive.impl;

import java.util.List;
import java.util.Map;

import com.bxm.localnews.mq.common.constant.ActionTypeEnum;
import com.bxm.localnews.mq.common.constant.ReceiverRuleParamConstant;
import com.bxm.localnews.mq.consume.push.receive.IReceiveUserIterator;
import com.bxm.localnews.msg.vo.UserDeviceBean;
import com.google.common.collect.Lists;

/**
 * @author zhaoyadong 2019/2/20 10:01
 * @desc
 */
public class UserVipReceiveUserIterator extends AbstractReceiveUserIterator {

    private List<String> getUserIds() {
        List<String> param = (List<String>) paramMap.get(ReceiverRuleParamConstant.USER_IDS);
        if (null == param) {
            return Lists.newArrayList();
        }
        return param;
    }

    /**
     * vip状态
     *
     * @return
     */
    private Byte getStatus() {
        Byte status = Byte.valueOf(paramMap.get(ReceiverRuleParamConstant.VIP).toString());
        if (ActionTypeEnum.VIP_ACTIVATION.getType().equals(status)) {
            status = 2;
        } else {
            status = 1;
        }
        return status;
    }

    @Override
    int getTotal() {
        return userDeviceMapper.getUserVipUserTotal(getUserIds(), getStatus());
    }

    @Override
    List<UserDeviceBean> queryByPage(int pageNum) {
        return userDeviceMapper.getUserVipUserList(getUserIds(), getStatus(), pageNum * pageSize, pageSize);
    }

    @Override
    public IReceiveUserIterator build(Map<String, Object> paramMap) {
        UserVipReceiveUserIterator iterator = new UserVipReceiveUserIterator();
        iterator.paramMap = paramMap;
        return iterator;
    }
}
