package com.bxm.localnews.mq.consume.service;


import java.util.List;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.dto.MessageTypeDTO;
import com.bxm.localnews.msg.param.MessageListParam;
import com.bxm.localnews.msg.vo.Message;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.vo.PageWarper;

/**
 * Created by Administrator on 2018/2/9 0009.
 */
public interface MessageService {


    /**
     * 获取未读的消息总数
     *
     * @param userId
     * @param platform
     * @return
     */
    int getUnReadMsg(Long userId, Integer platform);

    /**
     * 获取用户最新消息总数
     *
     * @param userId
     * @return 消息总数
     */
    int getNewMsg(Long userId);


    List<Message> queryNoticeList(Long userId, MPage page);

    Message noticeDetail(Integer id);

    PageWarper<Message> listMessage(MessageListParam messageListParam, BasicParam basicParam);

    MessageTypeDTO getMessageType(String areaCode, Long userId, BasicParam basicParam);

    /**
     * 获取对应类型的redis-key
     *
     * @param messageType
     * @return
     */
    KeyGenerator getMsgKeyByType(String messageType, Long userId);

    void updateMessageByType(Long userId, String messageType);

    /**
     * 添加消息
     *
     * @param message
     */
    Boolean addMessage(PushMessage message, Long userId);

    /**
     * 添加用户事件
     *
     * @param userId  用户id
     * @param msgType 消息类型
     * @return
     */
    Boolean addUserEvent(Long userId, String msgType);

    /**
     * 获取最近半个消息对应类型的所有未读消息
     *
     * @param type
     * @return
     */
    List<Message> interactionMessgeList(String type);

    /**
     * 推送模板消息
     *
     * @param pushMessage
     */
    void pushTemplateMessage(PushMessage pushMessage);
}
