package com.bxm.localnews.mq.consume.service.impl;

import java.util.Map;

import com.bxm.component.httpclient.service.HttpClientService;
import com.google.common.collect.Maps;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 示远API的模拟实现
 *
 * @author liujia
 */
@Component
public class ShiyuanApiImpl extends AbstractApiImpl {

    @Autowired
    private HttpClientService httpClientService;

    @Override
    String batchSend(String uri, String account, String pswd, String mobiles, String content, boolean needstatus, String product, String extno) throws Exception {
        return httpClientService.doGet(uri, generateParams(account, pswd, mobiles, content, needstatus, product, extno));
    }

    Map<String, String> generateParams(String account, String pswd, String mobiles, String content, boolean needstatus, String product, String extno) {
        Map<String, String> params = Maps.newHashMap();
        params.put("account", account);
        params.put("pswd", pswd);
        params.put("mobile", mobiles);
        params.put("needstatus", String.valueOf(needstatus));
        params.put("msg", content);
        params.put("product", product);
        params.put("extno", extno);
        return params;
    }
}
