package com.bxm.localnews.mq.handle;

import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.mq.common.constant.AppConst;
import com.bxm.localnews.mq.config.MessageProperties;
import com.bxm.localnews.mq.config.SmsOperatorConfig;
import com.bxm.localnews.mq.consume.service.SmsFactory;

import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/4/28 18:04
 * @desc
 */
@Component
@Log4j2
public class SmsMessageHandle {

    @Autowired
    private SmsOperatorConfig smsOperatorConfig;

    @Autowired
    private MessageProperties messageProperties;

    @Async
    public void send(Map<String, String> smsMap) {
        if (!messageProperties.getEnableSms()) {
            log.debug("短信未开启");
            log.debug(JSON.toJSONString(smsMap));
        }

        try {
            if ("shiyuan".equals(smsOperatorConfig.getOperator())) {
                String[] result = SmsFactory.send(AppConst.Sms.SHIYUAN, smsMap.get("phoneNo"), smsMap.get("content"));
                if (!result[0].equals("1")) {

                    log.error("短信消费失败:" + result[0] + ":" + result[1], smsMap.get("phoneNo") + ":" + smsMap.get("content"));

                } else {
                    log.debug("短信消费成功", result[0] + "," + result[1]);
                }
            }

            if ("chuanglan".equals(smsOperatorConfig.getOperator())) {
                String[] result = SmsFactory.send(AppConst.Sms.CHUANGLAN, smsMap.get("phoneNo"), smsMap.get("content"));
                if (!result[0].equals("0")) {

                    log.error("短信消费失败:" + result[0] + ":" + result[1], smsMap.get("phoneNo") + ":" + smsMap.get("content"));

                } else {
                    log.debug("短信消费成功", result[0] + "," + result[1]);
                }
            }
        } catch (Exception e) {
            //消费失败
            log.error("短信消费失败:" + e.getMessage(), e);
        }
    }
}
