package com.bxm.localnews.mq.produce.service.impl;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.mq.common.constant.AliMqMsgTagEnum;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.mq.consume.service.MessageService;
import com.bxm.localnews.mq.produce.service.AliMqService;
import com.bxm.localnews.mq.produce.service.PushMsgSupplyService;
import com.bxm.localnews.msg.vo.Message;
import com.bxm.newidea.component.service.BaseService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * Created by Arei on 2018/10/12.
 */
@Service("pushMsgSupplyService")
public class PushMsgSupplyServiceImpl extends BaseService implements PushMsgSupplyService {
    private static final Logger logger = LoggerFactory.getLogger(PushMsgSupplyServiceImpl.class);

    @Resource
    private AliMqService aliMqService;

    @Resource
    private MessageService messageService;

    @Override
    public void pushMsg(PushMessage message) {
        aliMqService.send(aliMqService.createMessage(AliMqMsgTagEnum.PUSH, message));

        messageService.pushTemplateMessage(message);
    }

    // TODO [liujia]逻辑修改，进行消费时才同步到用户
    //    private int saveMsg(Message msg) {
    //
    //        int result = messageMapper.insertSelective(msg);
    //
    //        //通知红点设置
    //        KeyGenerator redPointKey = RedisConfig.MSG_RED_POINT.copy().appendKey(msg.getUserId());
    //        redisStringAdapter.set(redPointKey, true);
    //
    //        return result;
    //    }
    //
    //
    //    private void batchSaveMessage(Set<String> userIds, Message message) {
    //        List<Message> messageList = new ArrayList<>();
    //        for (String userId : userIds) {
    //            Message msg = new Message();
    //            BeanUtils.copyProperties(message, msg);
    //            msg.setUserId(Long.valueOf(userId));
    //            messageList.add(msg);
    //        }
    //
    //        new BatchHelper<MessageMapper, Message>(MessageMapper.class, messageList) {
    //            @Override
    //            protected int invoke(Message element) {
    //                int result = this.domain.insertSelective(element);
    //
    //                //通知红点设置
    //                KeyGenerator redPointKey = RedisConfig.MSG_RED_POINT.copy().appendKey(element.getUserId());
    //                redisStringAdapter.set(redPointKey, true);
    //
    //                return result;
    //            }
    //        };
    //
    //    }

    @Override
    public void pushInteraction() {
        logger.info("---------- 互动消息未读推送开始 ------------");
        List<Message> messageList = messageService.interactionMessgeList("INTERACTION");
        if (CollectionUtils.isEmpty(messageList)) {
            logger.info("互动消息推送列表为空");
            return;
        }

        Map<Long, List<Message>> userMessageList = messageList.stream().collect(Collectors.groupingBy(Message::getUserId));
        userMessageList.forEach((userId, messages) -> {
            PushMessage pushMessage = PushMessage.build();

            Long msgId = nextId();
            if (messages.size() == 1) {
                pushMessage.setPersistence(false);
                Message message = messages.get(0);
                PushPayloadInfo payloadInfo = JSON.parseObject(message.getLinkParam(), PushPayloadInfo.class);
                pushMessage.setTitle(message.getTitle());
                pushMessage.setContent(message.getContent());
                pushMessage.setType(TemplateTypeEnum.NOTIFCTION);
                pushMessage.setPushReceiveScope(PushReceiveScope.pushSignle(userId));
                pushMessage.setPayloadInfo(payloadInfo);
            } else {
                pushMessage.setPersistence(true);
                Message message = messages.get(messages.size() - 1);
                PushPayloadInfo payloadInfo = JSON.parseObject(message.getLinkParam(), PushPayloadInfo.class);
                String name = payloadInfo.getExtend().get("nickname").toString();
                String title = "【" + name + "】等用户跟你有" + messages.size() + "条互动消息哦，快来看看吧";

                PushPayloadInfo info = PushPayloadInfo.build(PushMessageEnum.INTERACTION_MSG);
                info.setMsgId(msgId);
                info.addExtend("msgId", msgId);

                pushMessage.setTitle("");
                pushMessage.setContent(title);
                pushMessage.setType(TemplateTypeEnum.NOTIFCTION);
                pushMessage.setPushReceiveScope(PushReceiveScope.pushSignle(userId));
                pushMessage.setPayloadInfo(info);
            }
            pushMsg(pushMessage);
        });
        logger.info("---------- 互动消息未读推送结束 ------------");
    }
}
