package com.bxm.localnews.mq.produce.service.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import com.bxm.localnews.mq.common.RedisConfig;
import com.bxm.localnews.mq.common.constant.AppConst;
import com.bxm.localnews.mq.common.constant.SmsTemplateEnum;
import com.bxm.localnews.mq.common.model.dto.SendSmsResult;
import com.bxm.localnews.mq.config.SmsLimnitConfig;
import com.bxm.localnews.mq.handle.SmsMessageHandle;
import com.bxm.localnews.mq.produce.service.AliMqService;
import com.bxm.localnews.mq.produce.service.SmsSupplyService;
import com.bxm.localnews.msg.domain.SmsMapper;
import com.bxm.localnews.msg.vo.Sms;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.component.tools.StringUtils;

import org.apache.commons.lang3.ArrayUtils;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service("smsSupplyService")
@RefreshScope
public class SmsSupplyServiceImpl implements SmsSupplyService {

    @Resource
    private AliMqService aliMqService;

    @Resource
    private SmsMessageHandle smsMessageHandle;

    @Resource
    private RedisStringAdapter redisStringAdapter;

    @Resource
    private SmsMapper smsMapper;

    @Resource
    private SmsLimnitConfig smsLimnitConfig;

    @Override
    public SendSmsResult sendSmsByTemplate(String phoneNo, SmsTemplateEnum smsTemplate, String ip, String... params) {
        if (!sendSmsSafeLimit(phoneNo, ip, smsTemplate)) {
            return SendSmsResult.build(false, "该手机短信当天发送到达上限");
        }
        String smsContent = StringUtils.convertMessage(smsTemplate.getContent(), params);
        Map<String, String> smsMap = new HashMap<>();
        smsMap.put("phoneNo", phoneNo);
        smsMap.put("content", smsContent);
        //备注：取消消息队列发送短信 改为异步发送短信
//        Message smsMessage = aliMqService.createMessage(AliMqMsgTagEnum.SMS, smsMap);
//        aliMqService.send(smsMessage);
        smsMessageHandle.send(smsMap);
        saveSendSmsSafeNum(phoneNo, ip, smsTemplate);
        this.saveSmsRecord(phoneNo, null, ip, null, smsContent, null);
        return SendSmsResult.build(true, "验证码已发送，请注意查收");
    }

    @Override
    public SendSmsResult sendSmsByCustomize(String phoneNo, String smsContent) {
        Map<String, String> smsMap = new HashMap<>();
        smsMap.put("phoneNo", phoneNo);
        smsMap.put("content", smsContent);
        //备注：取消消息队列发送短信 改为异步发送短信
//        Message smsMessage = aliMqService.createMessage(AliMqMsgTagEnum.SMS, smsMap);
//        aliMqService.send(smsMessage);
        smsMessageHandle.send(smsMap);
        this.saveSmsRecord(phoneNo, null, null, null, smsContent, null);
        return SendSmsResult.build(true, "短信已发送");
    }

    @Override
    public void sendGroupSmsByTemplate(List<String> phoneNos, SmsTemplateEnum smsTemplate, String... params) {
        String smsContent = StringUtils.convertMessage(smsTemplate.getContent(), params);
        Map<String, String> smsMap = new HashMap<>();
        smsMap.put("content", smsContent);

        execSend(phoneNos, smsContent, smsMap);
    }

    @Override
    public void sendGroupSmsByCustomize(List<String> phoneNos, String smsContent) {
        Map<String, String> smsMap = new HashMap<>();
        smsMap.put("content", smsContent);

        execSend(phoneNos, smsContent, smsMap);
    }

    private void execSend(List<String> phoneNos, String smsContent, Map<String, String> smsMap) {
        for (String phoneNo : phoneNos) {
            smsMap.put("phoneNo", phoneNo);
            //备注：取消消息队列发送短信 改为异步发送短信
//        Message smsMessage = aliMqService.createMessage(AliMqMsgTagEnum.SMS, smsMap);
//        aliMqService.send(smsMessage);
            smsMessageHandle.send(smsMap);
            this.saveSmsRecord(phoneNo, null, null, null, smsContent, null);
        }
    }

    @Override
    public Boolean verifySmsCode(String phoneNo, String code, SmsTemplateEnum smsTemplate) {
        KeyGenerator key = RedisConfig.MESSAGE_SMS.copy().appendKey
                (smsTemplate.name().toLowerCase() + ":" + phoneNo);
        String vCode = redisStringAdapter.get(key, String.class);
        return code.equals(vCode);
    }

    @Override
    public Boolean verifySmsCodeByType(Byte type, String phoneNo, String code) {
        SmsTemplateEnum smsTemplateEnum = SmsTemplateEnum.getTemplateByType(type);
        return verifySmsCode(phoneNo, code, smsTemplateEnum);
    }

    @Override
    public SendSmsResult sendSmsByVCodeTemplate(String phoneNo, SmsTemplateEnum smsTemplate, String ip) {
        Assert.isTrue(smsTemplate.isVCodeType(), "模版类型不支持");
        String code = RandomUtils.getShortCode(4);

        KeyGenerator key = RedisConfig.MESSAGE_SMS.copy().appendKey(smsTemplate.name().toLowerCase() + ":" + phoneNo);
        //失效旧的未使用的验证码
        if (redisStringAdapter.hasKey(key)) {
            redisStringAdapter.remove(key);
        }
        redisStringAdapter.set(key, code, 10 * 60);
        return this.sendSmsByTemplate(phoneNo, smsTemplate, ip, code);
    }

    private boolean sendSmsSafeLimit(String phoneNo, String ip, SmsTemplateEnum templateEnum) {
        KeyGenerator dayKey = RedisConfig.MESSAGE_SMS.copy().appendKey("limit:" + templateEnum.name().toLowerCase() + ":" + phoneNo);
        boolean dayResult = (redisStringAdapter.getLong(dayKey).intValue() < smsLimnitConfig.getPhoneLimitPerDay());
        if (!org.springframework.util.StringUtils.isEmpty(ip)) {
            KeyGenerator ipKey = RedisConfig.MESSAGE_SMS.copy().appendKey("limit:" + templateEnum.name().toLowerCase() + ":" + ip);

            return dayResult &&
                    (redisStringAdapter.getLong(ipKey).intValue() < smsLimnitConfig.getIpLimitPerDay());
        }
        return dayResult;
    }

    private void saveSendSmsSafeNum(String phoneNo, String ip, SmsTemplateEnum templateEnum) {
        KeyGenerator dayKey = RedisConfig.MESSAGE_SMS.copy().appendKey("limit:" + templateEnum.name().toLowerCase() + ":" + phoneNo);
        redisStringAdapter.increment(dayKey);
        redisStringAdapter.expire(dayKey, DateUtils.getCurSeconds());
        if (!org.springframework.util.StringUtils.isEmpty(ip)) {
            KeyGenerator ipKey = RedisConfig.MESSAGE_SMS.copy().appendKey("limit:" + templateEnum.name().toLowerCase() + ":" + ip);
            redisStringAdapter.increment(ipKey);
            redisStringAdapter.expire(ipKey, DateUtils.getCurSeconds());
        }
    }

    /**
     * 保存短信发送结果至数据库
     *
     * @param phone   接收号码
     * @param type    短信类型
     * @param ip      发送IP
     * @param vcode   发送验证码
     * @param content 发送内容
     * @param result  发送结果
     */
    private void saveSmsRecord(String phone, Byte type, String ip, String vcode, String content, String[] result) {
        Date date = new Date();

        Sms sms = new Sms();

        sms.setPhone(phone);
        sms.setSendTime(date);
        sms.setSmsType(type);
        sms.setCode(vcode);
        sms.setState(AppConst.Sms.STATUS_UNUSED);
        if (ArrayUtils.isNotEmpty(result)) {
            sms.setResp(result[0]);
            sms.setContent(result[1]);
        }
        if (StringUtils.isNotBlank(content)) {
            sms.setContent(content);
        }
        sms.setIp(ip);
        sms.setRespTime(date);
        sms.setCreateTime(date);

        this.smsMapper.insertSelective(sms);
    }

}
