/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.action.subscribe;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.news.action.stream.MessageProcessor;
import com.bxm.localnews.news.enums.UserActionEnum;
import com.bxm.localnews.news.event.UserActionEvent;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.MessageChannel;
import org.springframework.stereotype.Component;

@Component
public class UserActionStreamSubscriber {
    private static final Logger log = LoggerFactory.getLogger(UserActionStreamSubscriber.class);
    private final MessageProcessor messageProcessor;
    private Map<UserActionEnum, MessageChannel> channelMap;

    @Autowired
    public UserActionStreamSubscriber(MessageProcessor messageProcessor) {
        this.messageProcessor = messageProcessor;
        this.initBindingChannel();
    }

    private void initBindingChannel() {
        this.channelMap = Maps.newHashMap();
        this.channelMap.put(UserActionEnum.VIEW, this.messageProcessor.viewOutput());
        this.channelMap.put(UserActionEnum.COLLECT, this.messageProcessor.collectOutput());
        this.channelMap.put(UserActionEnum.COMMENT, this.messageProcessor.commentOutput());
        this.channelMap.put(UserActionEnum.SHARE, this.messageProcessor.shareOutput());
        this.channelMap.put(UserActionEnum.NOTE, this.messageProcessor.noteOutput());
        this.channelMap.put(UserActionEnum.FORUM_POST, this.messageProcessor.forumPostOutput());
        this.channelMap.put(UserActionEnum.SHARE_FORUM, this.messageProcessor.shareForumOutput());
    }

    @Subscribe
    public void consume(UserActionEvent event) {
        MessageChannel messageChannel;
        if (log.isDebugEnabled()) {
            log.debug("\u6d88\u8d39\u7528\u6237\u884c\u4e3a\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)event));
        }
        if (null != (messageChannel = this.channelMap.get(event.getAction()))) {
            messageChannel.send(MessageBuilder.withPayload((Object)event).build());
            log.info("\u6d88\u8d39\u53d1\u9001\u6570\u636e\uff1a[{}]", (Object)JSON.toJSONString((Object)event));
        }
    }
}

