package com.bxm.localnews.news.constant;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;


/**
 * redis 缓存的key值，格式为： {业务类型：模块：子模块:更下级模块} 业务类型： biz:业务 config:配置
 */
public class RedisConfig {


    /**
     * ====================================================================== news 模块相关缓存键值 用户阅读推荐新闻获得奖励的次数
     */
    public static KeyGenerator RECOMMEND_NEWS_READ = DefaultKeyGenerator.build("news", "recommendNewsRead");

    /**
     * 用户阅读新闻获得奖励的次数
     */
    public static KeyGenerator NEWS_READ = DefaultKeyGenerator.build("news", "readnews");

    /**
     * 新闻类型缓存
     */
    public static KeyGenerator NEWS_KIND = DefaultKeyGenerator.build("news", "cache", "newskind");

    /**
     * 推荐给个人用户的小视频缓存，30分钟有效期
     */
    public static KeyGenerator VIDEO_RECOMMEND = DefaultKeyGenerator.build("video", "usercache");

    /**
     * 推荐给个人用户的小视频缓存，2小时有效期
     */
    public static KeyGenerator NEWS_RECOMMEND = DefaultKeyGenerator.build("news", "usercache");

    /**
     * 用户推荐新闻间隔
     */
    public static KeyGenerator NEWS_RECOMMEND_INTERVAL = DefaultKeyGenerator.build("news", "recommend",
            "interval");

    /**
     * 用户频道缓存
     */
    public static KeyGenerator NEWS_USER_KIND = DefaultKeyGenerator.build("news", "kind", "user_list");

    /**
     * 用户频道set缓存
     */
    public static KeyGenerator NEWS_USER_KIND_SET = DefaultKeyGenerator.build("news", "kind", "user_set");

    /**
     * 小视频队列
     */
    public static KeyGenerator VIDEO_QUEUE = DefaultKeyGenerator.build("video", "queue");

    /**
     * 新闻队列
     */
    public static KeyGenerator NEWS_QUEUE = DefaultKeyGenerator.build("news", "queue");

    /**
     * 首页置顶列表缓存key
     */
    public static KeyGenerator TOP_NEW_LIST = DefaultKeyGenerator.build("news", "top");

    /**
     * 首页区域性置顶列表缓存key
     */
    public static KeyGenerator TOP_NEW_OF_AREA_LIST = DefaultKeyGenerator.build("news", "top");

    /**
     * 首页全国性置顶列表缓存key
     */
    public static KeyGenerator TOP_NEW_OF_WHOLE_COUNTRY_LIST = DefaultKeyGenerator.build("news", "top",
            "wholeCountry");

    /**
     * 用户信息缓存
     */
    public static KeyGenerator USER_INFO = DefaultKeyGenerator.build("user", "cache", "userInfo");

    /**
     * 用户当日分享新闻记录 ,有效期:当天
     */
    public static KeyGenerator USER_SHARE_NEWS_RECORD = DefaultKeyGenerator.build("activity", "task",
            "usersharenews");
}
