package com.bxm.localnews.news.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 客户端路由表配置
 *
 * @author wzy
 * @version 1.0
 * @date 2020/12/25 4:33 下午
 */
@Component
@ConfigurationProperties("forum.config.client.route")
@Data
public class ClientRouteProperties {
    /**
     * vip页面
     */
    private String vipPage = "wst://function/tabbarIndex?className_iOS=TTNormalWebVC&tabName=vip";

    /**
     * H5容器
     */
    private String webView = "wst://web/webDetail?url=%s&webTitle=%s&isFlowerStore=0";
}