package com.bxm.localnews.news.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @author gonzo
 * @date 2020-09-24 20:21
 **/
@Component
@ConfigurationProperties("forum.config.replace")
@Data
public class NewsContentReplaceProperties {

    /**
     * 站内炫耀帖子的跳转地址
     */
    private String lotteryFlauntProtocol = "tk/raffle.html#/raffleIndex?userId=%s&areaCode=%s&areaName=%s";

    /**
     * 站内炫耀帖子的跳转地址
     * 这个地址会走一层重定向，因为老版本android有bug，无法跳转
     */
    private String lotteryFlauntOldAndroidProtocol = "r/raffleIndex?userId=%s&areaCode=%s&areaName=%s";

    /**
     * 站外炫耀帖子的跳转地址 就是应用宝地址
     */
    private String lotteryFlauntUrl = "https://a.app.qq.com/o/simple.jsp?pkgname=com.bxm.localmastercard";

    /**
     * 站外炫耀帖子的点击文案
     */
    private String lotteryFlauntText = "去app参与夺宝";

}
