package com.bxm.localnews.news.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;

/**
 * 热文分享相关配置
 *
 * @author wzy
 * @version 1.0
 * @date 2021/1/18 5:50 下午
 */
@Component
@ConfigurationProperties("forum.config.share.post")
@Data
public class SharePostCashProperties {

    /**
     * 用户每日奖励上限
     */
    private BigDecimal limitAward = new BigDecimal("100");

    /**
     * 官方账号列表，需要从热文排行榜中剔除
     */
    private List<Long> officialAccountList = Collections.emptyList();
}