package com.bxm.localnews.news.constant;

import com.bxm.newidea.component.sync.key.DefaultCacheKeyGenerator;

/**
 * 内存缓存的相关键值定义
 *
 * @author liujia
 * @date 1/21/21 10:00 PM
 **/
public class MemoryCacheKey {
    private MemoryCacheKey() {
    }

    public static DefaultCacheKeyGenerator TOPIC_CACHE = DefaultCacheKeyGenerator.build("news", "topic");

    public static DefaultCacheKeyGenerator TOPIC_AREA_CACHE = DefaultCacheKeyGenerator.build("news", "topicArea");

    /**
     * 帖子的参与人数
     */
    public static DefaultCacheKeyGenerator TOPIC_PARTICIPANT_NUM = DefaultCacheKeyGenerator.build(
            "news",
            "topicParticipantNum");

    /**
     * 热门回复信息
     */
    public static DefaultCacheKeyGenerator HOT_REPLY_CACHE = DefaultCacheKeyGenerator.build("replay", "hot");

    /**
     * 回复的总数统计逻辑
     */
    public static DefaultCacheKeyGenerator REPLY_COUNT_CACHE = DefaultCacheKeyGenerator.build("replay", "count");

    /**
     * 用户的最后发帖事件（用于判断是否有新的发帖）
     */
    public static DefaultCacheKeyGenerator LAST_POST_TIME_CACHE = DefaultCacheKeyGenerator.build("news", "lastPost");

    /**
     * 用户信息缓存
     */
    public static DefaultCacheKeyGenerator USER_LOCAL_CACHE = DefaultCacheKeyGenerator.build("user", "info");

    /**
     * 用户是否为虚拟用户
     */
    public static DefaultCacheKeyGenerator USER_VIRTUAL_TYPE_CACHE = DefaultCacheKeyGenerator.build("user", "virtualType");
}
